/*
 * Decompiled with CFR 0.152.
 */
package de.siegmar.logbackgelf.compressor;

import de.siegmar.logbackgelf.compressor.Compressor;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.zip.GZIPOutputStream;

public class GZIPCompressor
implements Compressor {
    @Override
    public byte[] compress(byte[] binMessage) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream(binMessage.length);
        try (GZIPOutputStream gzipOut = new GZIPOutputStream(bos);){
            gzipOut.write(binMessage);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return bos.toByteArray();
    }
}

