/*
 * Decompiled with CFR 0.152.
 */
package de.siegmar.logbackgelf;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.UnsynchronizedAppenderBase;
import de.siegmar.logbackgelf.CompressionMethod;
import de.siegmar.logbackgelf.GelfEncoder;
import de.siegmar.logbackgelf.NoopX509TrustManager;
import de.siegmar.logbackgelf.RetryUtil;
import de.siegmar.logbackgelf.compressor.Compressor;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.time.Duration;
import java.util.Optional;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;

public class GelfHttpAppender
extends UnsynchronizedAppenderBase<ILoggingEvent> {
    private static final int DEFAULT_CONNECT_TIMEOUT = 15000;
    private static final int DEFAULT_REQUEST_TIMEOUT = 5000;
    private static final int DEFAULT_MAX_RETRIES = 2;
    private static final int DEFAULT_RETRY_DELAY = 3000;
    private URI uri;
    private boolean insecure;
    private int connectTimeout = 15000;
    private int requestTimeout = 5000;
    private int maxRetries = 2;
    private int retryDelay = 3000;
    private CompressionMethod compressionMethod = CompressionMethod.GZIP;
    private HttpClient httpClient;
    private GelfEncoder encoder;
    private Compressor compressor;

    public String getUri() {
        return this.uri.toString();
    }

    public void setUri(String uri) {
        this.uri = URI.create(uri);
    }

    public boolean isInsecure() {
        return this.insecure;
    }

    public void setInsecure(boolean insecure) {
        this.insecure = insecure;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public int getRequestTimeout() {
        return this.requestTimeout;
    }

    public void setRequestTimeout(int requestTimeout) {
        this.requestTimeout = requestTimeout;
    }

    public int getMaxRetries() {
        return this.maxRetries;
    }

    public void setMaxRetries(int maxRetries) {
        this.maxRetries = maxRetries;
    }

    public int getRetryDelay() {
        return this.retryDelay;
    }

    public void setRetryDelay(int retryDelay) {
        this.retryDelay = retryDelay;
    }

    public CompressionMethod getCompressionMethod() {
        return this.compressionMethod;
    }

    public void setCompressionMethod(CompressionMethod compressionMethod) {
        this.compressionMethod = compressionMethod;
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    public void setHttpClient(HttpClient httpClient) {
        this.httpClient = httpClient;
    }

    public GelfEncoder getEncoder() {
        return this.encoder;
    }

    public void setEncoder(GelfEncoder encoder) {
        this.encoder = encoder;
    }

    public void start() {
        if (this.uri == null) {
            this.addError("URI is required");
            return;
        }
        if (this.encoder == null) {
            this.encoder = new GelfEncoder();
            this.encoder.setContext(this.getContext());
            this.encoder.start();
        } else if (this.encoder.isAppendNewline()) {
            this.addError("Newline separator must not be enabled in layout");
            return;
        }
        if (this.httpClient == null) {
            try {
                this.httpClient = this.buildHttpClient();
            }
            catch (KeyManagementException | NoSuchAlgorithmException e) {
                this.addError("Failed to create HttpClient", e);
                return;
            }
        }
        this.compressor = this.compressionMethod.getCompressor();
        super.start();
    }

    private HttpClient buildHttpClient() throws NoSuchAlgorithmException, KeyManagementException {
        HttpClient.Builder builder = HttpClient.newBuilder().version(HttpClient.Version.HTTP_2).connectTimeout(Duration.ofMillis(this.connectTimeout));
        if (this.insecure) {
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(null, new TrustManager[]{new NoopX509TrustManager()}, new SecureRandom());
            builder.sslContext(sslContext);
        }
        return builder.build();
    }

    protected void append(ILoggingEvent event) {
        try {
            HttpRequest request = this.buildRequest(this.buildPackage(event));
            RetryUtil.retry(() -> this.sendRequest(request), () -> ((GelfHttpAppender)this).isStarted(), this.maxRetries, this.retryDelay);
        }
        catch (Exception e) {
            this.addError(String.format("Error sending message via %s", this.getUri()), e);
        }
    }

    private byte[] buildPackage(ILoggingEvent event) {
        return this.compressor.compress(this.encoder.encode(event));
    }

    private HttpRequest buildRequest(byte[] data) {
        HttpRequest.Builder reqB = HttpRequest.newBuilder(this.uri).header("Content-Type", "application/json").timeout(Duration.ofMillis(this.requestTimeout));
        this.contentEncoding().ifPresent(encoding -> reqB.header("Content-Encoding", (String)encoding));
        return reqB.POST(HttpRequest.BodyPublishers.ofByteArray(data)).build();
    }

    private Optional<String> contentEncoding() {
        switch (this.compressionMethod) {
            case GZIP: {
                return Optional.of("gzip");
            }
            case ZLIB: {
                return Optional.of("deflate");
            }
            case NONE: {
                return Optional.empty();
            }
        }
        throw new IllegalStateException("Unknown compression method: " + this.compressionMethod);
    }

    private int sendRequest(HttpRequest request) throws IOException, InterruptedException {
        HttpResponse<String> response = this.httpClient.send(request, HttpResponse.BodyHandlers.ofString());
        int statusCode = response.statusCode();
        if (statusCode >= 500) {
            throw new IllegalStateException(String.format("Error sending message via %s. Code: %s; Message: %s", this.getUri(), response.statusCode(), response.body()));
        }
        if (statusCode != 202) {
            this.addError(String.format("Invalid response from %s. Code: %s; Message: %s", this.getUri(), response.statusCode(), response.body()));
        }
        return statusCode;
    }

    public void stop() {
        this.encoder.stop();
        super.stop();
    }
}

