/*
 * Decompiled with CFR 0.152.
 */
package de.siegmar.logbackgelf;

import java.util.concurrent.Callable;
import java.util.function.BooleanSupplier;

final class RetryUtil {
    private RetryUtil() {
    }

    public static <T> T retry(Callable<T> action, BooleanSupplier retryCondition, int maxRetries, long retryDelay) {
        int retryCount = 0;
        while (true) {
            try {
                return action.call();
            }
            catch (Exception e) {
                if (++retryCount > maxRetries || !retryCondition.getAsBoolean()) {
                    RetryUtil.rethrow(e);
                }
                try {
                    Thread.sleep(retryDelay);
                    continue;
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                    RetryUtil.rethrow(e);
                    continue;
                }
            }
            break;
        }
    }

    private static void rethrow(Exception e) {
        if (e instanceof RuntimeException) {
            throw (RuntimeException)e;
        }
        throw new IllegalStateException(e);
    }
}

