/*
 * Decompiled with CFR 0.152.
 */
package de.siegmar.logbackgelf;

import ch.qos.logback.core.util.CloseUtil;
import de.siegmar.logbackgelf.AddressResolver;
import de.siegmar.logbackgelf.pool.BasePooledObject;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import javax.net.SocketFactory;

public class TcpConnection
extends BasePooledObject {
    private final AddressResolver addressResolver;
    private final SocketFactory socketFactory;
    private final int port;
    private final int connectTimeout;
    private final int socketTimeout;
    private volatile OutputStream outputStream;

    TcpConnection(SocketFactory socketFactory, AddressResolver addressResolver, int port, int connectTimeout, int socketTimeout) {
        this.addressResolver = addressResolver;
        this.socketFactory = socketFactory;
        this.port = port;
        this.connectTimeout = connectTimeout;
        this.socketTimeout = socketTimeout;
    }

    public void write(byte[] messageToSend) throws IOException {
        if (this.outputStream == null) {
            this.connect();
        }
        this.outputStream.write(messageToSend);
        this.outputStream.write(0);
        this.outputStream.flush();
    }

    private void connect() throws IOException {
        Socket socket = this.socketFactory.createSocket();
        socket.setSoTimeout(this.socketTimeout);
        InetAddress ip = this.addressResolver.resolve();
        socket.connect(new InetSocketAddress(ip, this.port), this.connectTimeout);
        this.outputStream = socket.getOutputStream();
    }

    @Override
    protected void close() {
        CloseUtil.closeQuietly((Closeable)this.outputStream);
    }
}

