/*
 * Decompiled with CFR 0.152.
 */
package de.siegmar.logbackgelf.compressor;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;

public interface Compressor {
    default public byte[] compress(byte[] binMessage) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream(binMessage.length);
        try (OutputStream wrappedOut = this.wrap(bos);){
            wrappedOut.write(binMessage);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return bos.toByteArray();
    }

    default public OutputStream wrap(OutputStream out) throws IOException {
        return out;
    }
}

