/*
 * Decompiled with CFR 0.152.
 */
package de.siegmar.logbackgelf;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.UnsynchronizedAppenderBase;
import ch.qos.logback.core.encoder.Encoder;
import de.siegmar.logbackgelf.GelfEncoder;
import java.io.IOException;

public abstract class AbstractGelfAppender
extends UnsynchronizedAppenderBase<ILoggingEvent> {
    private static final int DEFAULT_GELF_PORT = 12201;
    private String graylogHost;
    private int graylogPort = 12201;
    private Encoder<ILoggingEvent> encoder;

    public String getGraylogHost() {
        return this.graylogHost;
    }

    public void setGraylogHost(String graylogHost) {
        this.graylogHost = graylogHost;
    }

    public int getGraylogPort() {
        return this.graylogPort;
    }

    public void setGraylogPort(int graylogPort) {
        this.graylogPort = graylogPort;
    }

    public Encoder<ILoggingEvent> getEncoder() {
        return this.encoder;
    }

    public void setEncoder(Encoder<ILoggingEvent> encoder) {
        this.encoder = encoder;
    }

    public final void start() {
        if (this.graylogHost == null) {
            this.addError("No graylogHost configured");
            return;
        }
        if (this.encoder == null) {
            this.encoder = new GelfEncoder();
            this.encoder.setContext(this.getContext());
            this.encoder.start();
        } else if (this.encoder instanceof GelfEncoder && ((GelfEncoder)this.encoder).isAppendNewline()) {
            this.addError("Newline separator must not be enabled in layout");
            return;
        }
        try {
            this.startAppender();
            super.start();
        }
        catch (Exception e) {
            this.addError("Couldn't start appender", e);
        }
    }

    protected abstract void startAppender() throws IOException;

    protected void append(ILoggingEvent event) {
        byte[] binMessage = this.encoder.encode((Object)event);
        try {
            this.appendMessage(binMessage);
        }
        catch (Exception e) {
            this.addError("Error sending GELF message", e);
        }
    }

    protected abstract void appendMessage(byte[] var1) throws IOException;

    public void stop() {
        super.stop();
        try {
            this.close();
        }
        catch (IOException e) {
            this.addError("Couldn't close appender", e);
        }
    }

    protected abstract void close() throws IOException;
}

