/*
 * Decompiled with CFR 0.152.
 */
package de.siegmar.logbackgelf;

import de.siegmar.logbackgelf.HostnameVerifier;
import java.security.cert.CertificateException;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.naming.InvalidNameException;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import javax.net.ssl.X509TrustManager;

class CustomX509TrustManager
implements X509TrustManager {
    private static final int TYPE_DNS_NAME = 2;
    private final X509TrustManager trustManager;
    private final String hostname;

    CustomX509TrustManager(X509TrustManager trustManager, String hostname) {
        this.trustManager = trustManager;
        this.hostname = hostname;
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        this.trustManager.checkServerTrusted(chain, authType);
        X509Certificate serverCert = chain[0];
        if (this.checkAlternativeNames(serverCert)) {
            return;
        }
        this.checkCommonName(serverCert);
    }

    private boolean checkAlternativeNames(X509Certificate serverCert) throws CertificateException {
        List<String> alternativeNames = CustomX509TrustManager.getAlternativeNames(serverCert);
        if (!alternativeNames.isEmpty()) {
            for (String alternativeName : alternativeNames) {
                if (!HostnameVerifier.verify(this.hostname, alternativeName)) continue;
                return true;
            }
            throw new CertificateException(String.format("Server certificate mismatch. Tried to verify %s against subject alternative names: %s", this.hostname, alternativeNames));
        }
        return false;
    }

    private static List<String> getAlternativeNames(X509Certificate cert) throws CertificateParsingException {
        Collection<List<?>> subjectAlternativeNames = cert.getSubjectAlternativeNames();
        if (subjectAlternativeNames == null) {
            return Collections.emptyList();
        }
        ArrayList<String> ret = new ArrayList<String>();
        for (List<?> entry : subjectAlternativeNames) {
            String dNSName;
            if ((Integer)entry.get(0) != 2 || (dNSName = (String)entry.get(1)) == null) continue;
            ret.add(dNSName);
        }
        return ret;
    }

    private void checkCommonName(X509Certificate serverCert) throws CertificateException {
        String commonName;
        try {
            commonName = CustomX509TrustManager.getCommonName(serverCert);
            if (HostnameVerifier.verify(this.hostname, commonName)) {
                return;
            }
        }
        catch (InvalidNameException e) {
            throw new CertificateException("Could not read CN from certificate", e);
        }
        throw new CertificateException(String.format("Server certificate mismatch. Tried to verify %s against common name: %s", this.hostname, commonName));
    }

    private static String getCommonName(X509Certificate cert) throws InvalidNameException {
        LdapName ldapName = new LdapName(cert.getSubjectDN().getName());
        for (Rdn rdn : ldapName.getRdns()) {
            if (!"CN".equalsIgnoreCase(rdn.getType())) continue;
            return (String)rdn.getValue();
        }
        throw new InvalidNameException("No common name found");
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return this.trustManager.getAcceptedIssuers();
    }
}

