/*
 * Decompiled with CFR 0.152.
 */
package de.skuzzle.inject.async.guice;

import com.google.inject.Binder;
import com.google.inject.Injector;
import com.google.inject.Module;
import de.skuzzle.inject.async.guice.Feature;
import de.skuzzle.inject.async.guice.GuiceAsync;
import de.skuzzle.inject.async.guice.Keys;
import de.skuzzle.inject.async.guice.ScheduleFeature;
import de.skuzzle.inject.async.guice.Shutdown;
import de.skuzzle.inject.async.methods.AsyncModule;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum DefaultFeatures implements Feature
{
    ASYNC{

        @Override
        public void installModuleTo(Binder binder, GuiceAsync principal) {
            binder.install((Module)new AsyncModule(principal));
        }

        @Override
        public boolean cleanupExecutor(Injector injector, long timeout, TimeUnit timeUnit) {
            ExecutorService executor = (ExecutorService)injector.getInstance(Keys.DEFAULT_EXECUTOR_KEY);
            if (!Shutdown.executor(executor, timeout, timeUnit)) {
                LOG.warn("There are still active tasks lingering in default executor after shutdown. Wait time: {} {}", (Object)timeout, (Object)timeUnit);
                return false;
            }
            return true;
        }
    }
    ,
    SCHEDULE{

        @Override
        public void installModuleTo(Binder binder, GuiceAsync principal) {
            ScheduleFeature.DEFAULT.installModuleTo(binder, principal);
        }

        @Override
        public boolean cleanupExecutor(Injector injector, long timeout, TimeUnit timeUnit) {
            return ScheduleFeature.DEFAULT.cleanupExecutor(injector, timeout, timeUnit);
        }
    };

    private static final Logger LOG;

    static {
        LOG = LoggerFactory.getLogger(DefaultFeatures.class);
    }
}

