/*
 * Decompiled with CFR 0.152.
 */
package de.skuzzle.inject.async.guice;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Provides;
import de.skuzzle.inject.async.guice.DefaultBinding;
import de.skuzzle.inject.async.guice.DefaultFeatures;
import de.skuzzle.inject.async.guice.Feature;
import de.skuzzle.inject.async.guice.GuiceAsyncService;
import de.skuzzle.inject.async.guice.GuiceAsyncServiceImpl;
import java.util.Set;
import java.util.concurrent.ThreadFactory;
import javax.inject.Singleton;

public final class GuiceAsync {
    private GuiceAsync() {
    }

    public static void enableFor(Binder binder) {
        GuiceAsync.enableFeaturesFor(binder, DefaultFeatures.ASYNC, DefaultFeatures.SCHEDULE);
    }

    public static void enableFeaturesFor(Binder binder, Feature ... features) {
        Preconditions.checkArgument((binder != null ? 1 : 0) != 0, (Object)"binder must not be null");
        binder.install(GuiceAsync.createModuleWithFeatures(features));
    }

    public static Module createModule() {
        return GuiceAsync.createModuleWithFeatures(DefaultFeatures.ASYNC, DefaultFeatures.SCHEDULE);
    }

    public static Module createModuleWithFeatures(Feature ... features) {
        GuiceAsync principal = new GuiceAsync();
        ImmutableSet featureSet = ImmutableSet.copyOf((Object[])features);
        return new GuiceAsyncModule(principal, (Set<Feature>)featureSet);
    }

    private static final class GuiceAsyncModule
    extends AbstractModule {
        private final GuiceAsync principal;
        private final Set<Feature> enabledFeatures;

        public GuiceAsyncModule(GuiceAsync principal, Set<Feature> features) {
            Preconditions.checkArgument((!features.isEmpty() ? 1 : 0) != 0, (Object)"Set of features must not be empty");
            this.principal = principal;
            this.enabledFeatures = features;
        }

        protected void configure() {
            this.enabledFeatures.forEach(feature -> feature.installModuleTo(this.binder(), this.principal));
            this.bind(GuiceAsyncService.class).to(GuiceAsyncServiceImpl.class).in(Singleton.class);
        }

        @Provides
        @Singleton
        @DefaultBinding
        Set<Feature> provideFeatures() {
            return this.enabledFeatures;
        }

        @Provides
        @Singleton
        @DefaultBinding
        ThreadFactory provideThreadFactory() {
            return new ThreadFactoryBuilder().setNameFormat("guice-async-%d").build();
        }

        public int hashCode() {
            return 31;
        }

        public boolean equals(Object obj) {
            return obj instanceof GuiceAsyncModule;
        }
    }
}

