/*
 * Decompiled with CFR 0.152.
 */
package de.skuzzle.inject.async.guice;

import com.google.common.base.Preconditions;
import com.google.inject.Binder;
import com.google.inject.Injector;
import com.google.inject.Module;
import de.skuzzle.inject.async.guice.Feature;
import de.skuzzle.inject.async.guice.GuiceAsync;
import de.skuzzle.inject.async.guice.Keys;
import de.skuzzle.inject.async.guice.Shutdown;
import de.skuzzle.inject.async.schedule.ScheduleModule;
import de.skuzzle.inject.async.schedule.ScheduleProperties;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScheduleFeature
implements Feature {
    private static final Logger LOG = LoggerFactory.getLogger(ScheduleFeature.class);
    public static final ScheduleFeature DEFAULT = ScheduleFeature.withProperties(ScheduleProperties.defaultProperties());
    private final ScheduleProperties scheduleProperties;

    private ScheduleFeature(ScheduleProperties scheduleProperties) {
        Preconditions.checkArgument((scheduleProperties != null ? 1 : 0) != 0, (Object)"scheduleProperties must not be null");
        this.scheduleProperties = scheduleProperties;
    }

    public static ScheduleFeature withProperties(ScheduleProperties scheduleProperties) {
        return new ScheduleFeature(scheduleProperties);
    }

    @Override
    public void installModuleTo(Binder binder, GuiceAsync principal) {
        binder.install((Module)new ScheduleModule(principal, this.scheduleProperties));
    }

    @Override
    public boolean cleanupExecutor(Injector injector, long timeout, TimeUnit timeUnit) {
        ScheduledExecutorService scheduler = (ScheduledExecutorService)injector.getInstance(Keys.DEFAULT_SCHEDULER_KEY);
        if (!Shutdown.executor(scheduler, timeout, timeUnit)) {
            LOG.warn("There are still active tasks lingering in default scheduler after shutdown. Wait time: {} {}", (Object)timeout, (Object)timeUnit);
            return false;
        }
        return true;
    }
}

