/*
 * Decompiled with CFR 0.152.
 */
package de.skuzzle.inject.async.methods;

import com.google.common.base.Preconditions;
import com.google.inject.AbstractModule;
import com.google.inject.Provides;
import com.google.inject.matcher.Matchers;
import de.skuzzle.inject.async.guice.DefaultBinding;
import de.skuzzle.inject.async.guice.GuiceAsync;
import de.skuzzle.inject.async.methods.AsynchronousMethodInterceptor;
import de.skuzzle.inject.async.methods.annotation.Async;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import javax.inject.Singleton;
import org.aopalliance.intercept.MethodInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AsyncModule
extends AbstractModule {
    private static final Logger LOG = LoggerFactory.getLogger(AsyncModule.class);

    public AsyncModule(GuiceAsync principal) {
        Preconditions.checkArgument((principal != null ? 1 : 0) != 0, (Object)"instantiating this module is not allowed. Use the class GuiceAsync to enable asynchronous method support.");
    }

    protected void configure() {
        AsynchronousMethodInterceptor asyncInterceptor = new AsynchronousMethodInterceptor();
        this.requestInjection(asyncInterceptor);
        this.bindInterceptor(Matchers.any(), Matchers.annotatedWith(Async.class), new MethodInterceptor[]{asyncInterceptor});
        LOG.debug("Guice asynchronous method extension has been installed");
    }

    @Provides
    @Singleton
    @DefaultBinding
    ExecutorService provideDefaultExecutor(@DefaultBinding ThreadFactory threadFactory) {
        return Executors.newCachedThreadPool(threadFactory);
    }
}

