/*
 * Decompiled with CFR 0.152.
 */
package de.skuzzle.inject.async.methods;

import com.google.common.base.MoreObjects;
import com.google.common.base.Throwables;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.function.Supplier;
import org.aopalliance.intercept.MethodInvocation;

public class InvocationCallable<T>
implements Callable<T>,
Supplier<T> {
    private final MethodInvocation invocation;

    private InvocationCallable(MethodInvocation invocation) {
        this.invocation = invocation;
    }

    public static InvocationCallable<?> fromInvocation(MethodInvocation invocation) {
        return new InvocationCallable(invocation);
    }

    @Override
    public T call() throws Exception {
        try {
            Object result = this.invocation.proceed();
            if (result instanceof Future) {
                return (T)((Future)result).get();
            }
            if (result != null) {
                throw new IllegalStateException("Wrapped invocation is expected to either return null or an instance of (Completable)Future");
            }
            return null;
        }
        catch (Throwable e) {
            Throwables.throwIfInstanceOf((Throwable)e, Exception.class);
            throw new RuntimeException(e);
        }
    }

    @Override
    public T get() {
        try {
            return this.call();
        }
        catch (Exception e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("invocation", (Object)this.invocation).toString();
    }
}

