/*
 * Decompiled with CFR 0.152.
 */
package de.skuzzle.inject.async.schedule;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import de.skuzzle.inject.async.schedule.InjectedMethodInvocation;
import java.lang.reflect.InvocationTargetException;

class InvokeMethodRunnable
implements Runnable {
    private final InjectedMethodInvocation invocation;

    private InvokeMethodRunnable(InjectedMethodInvocation invocation) {
        this.invocation = invocation;
    }

    public static Runnable of(InjectedMethodInvocation invocation) {
        Preconditions.checkArgument((invocation != null ? 1 : 0) != 0);
        return new InvokeMethodRunnable(invocation);
    }

    @Override
    public void run() {
        try {
            this.invocation.proceed();
        }
        catch (InvocationTargetException e) {
            Throwables.throwIfUnchecked((Throwable)e.getTargetException());
            throw new RuntimeException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("invocation", (Object)this.invocation).toString();
    }
}

