/*
 * Decompiled with CFR 0.152.
 */
package de.skuzzle.inject.async.schedule;

import com.google.common.base.Preconditions;
import com.google.inject.Key;
import com.google.inject.Provider;
import com.google.inject.Scope;
import com.google.inject.Scopes;
import java.util.Map;

public class MapBasedScope
implements Scope {
    private final Provider<Map<String, Object>> mapProvider;

    private MapBasedScope(Provider<Map<String, Object>> mapProvider) {
        this.mapProvider = mapProvider;
    }

    public static Scope withMapSupplier(Provider<Map<String, Object>> mapProvider) {
        Preconditions.checkArgument((mapProvider != null ? 1 : 0) != 0, (Object)"mapProvider is null");
        return new MapBasedScope(mapProvider);
    }

    public <T> Provider<T> scope(Key<T> key, Provider<T> unscoped) {
        String name = key.toString();
        return () -> {
            Map beans;
            Map map = beans = (Map)this.mapProvider.get();
            synchronized (map) {
                Object bean = beans.get(name);
                if (bean == NullObject.INSTANCE) {
                    return null;
                }
                Object t = bean;
                if (t == null && !Scopes.isCircularProxy(t = unscoped.get())) {
                    beans.put(name, t == null ? NullObject.INSTANCE : t);
                }
                return t;
            }
        };
    }

    private static enum NullObject {
        INSTANCE;

    }
}

