/*
 * Decompiled with CFR 0.152.
 */
package de.skuzzle.inject.async.schedule;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import de.skuzzle.inject.async.schedule.ExceptionHandler;
import de.skuzzle.inject.async.schedule.InjectedMethodInvocation;
import de.skuzzle.inject.async.schedule.InvokeMethodRunnable;
import de.skuzzle.inject.async.schedule.LockableRunnable;
import de.skuzzle.inject.async.schedule.ScheduledContextImpl;
import java.util.concurrent.CountDownLatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class Runnables {
    private static final Logger LOG = LoggerFactory.getLogger(LatchLockableRunnable.class);

    Runnables() {
    }

    static LockableRunnable createLockedRunnableStack(InjectedMethodInvocation invocation, ScheduledContextImpl context, ExceptionHandler handler) {
        return LatchLockableRunnable.locked(ScopedRunnable.of(ExceptionHandlingRunnable.of(InvokeMethodRunnable.of(invocation), handler), context));
    }

    private static class ExceptionHandlingRunnable
    implements Runnable {
        private final Runnable wrapped;
        private final ExceptionHandler handler;

        private ExceptionHandlingRunnable(Runnable wrapped, ExceptionHandler handler) {
            this.wrapped = wrapped;
            this.handler = handler;
        }

        public static Runnable of(Runnable wrapped, ExceptionHandler handler) {
            return new ExceptionHandlingRunnable(wrapped, handler);
        }

        @Override
        public void run() {
            try {
                this.wrapped.run();
            }
            catch (Exception e) {
                this.handler.onException(e);
            }
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("wrapped", (Object)this.wrapped).toString();
        }
    }

    private static class ScopedRunnable
    implements Runnable {
        private final Runnable wrapped;
        private final ScheduledContextImpl context;

        private ScopedRunnable(Runnable wrapped, ScheduledContextImpl context) {
            this.wrapped = wrapped;
            this.context = context;
        }

        static Runnable of(Runnable wrapped, ScheduledContextImpl context) {
            Preconditions.checkArgument((wrapped != null ? 1 : 0) != 0, (Object)"wrapped is null");
            Preconditions.checkArgument((context != null ? 1 : 0) != 0, (Object)"context is null");
            return new ScopedRunnable(wrapped, context);
        }

        @Override
        public void run() {
            try {
                this.context.beginNewExecution();
                this.wrapped.run();
            }
            finally {
                this.context.finishExecution();
            }
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("wrapped", (Object)this.wrapped).add("context", (Object)this.context).toString();
        }
    }

    static class LatchLockableRunnable
    implements LockableRunnable {
        private final Runnable runnable;
        private final CountDownLatch latch;

        private LatchLockableRunnable(Runnable runnable) {
            this.runnable = runnable;
            this.latch = new CountDownLatch(1);
        }

        public static LockableRunnable locked(Runnable runnable) {
            return new LatchLockableRunnable(runnable);
        }

        @Override
        public void run() {
            try {
                LOG.trace("Waiting for approval");
                this.latch.await();
                LOG.trace("Executing wrapped runnable: {}", (Object)this.runnable);
                this.runnable.run();
            }
            catch (InterruptedException e) {
                LOG.error("Interrupted while waiting to begin execution. Execution of {} has been skipped.", (Object)this.runnable, (Object)e);
                Thread.currentThread().interrupt();
            }
        }

        @Override
        public LockableRunnable release() {
            this.latch.countDown();
            return this;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("runnable", (Object)this.runnable).toString();
        }
    }
}

