/*
 * Decompiled with CFR 0.152.
 */
package de.skuzzle.inject.async.schedule;

import com.google.common.base.Preconditions;
import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.Injector;
import com.google.inject.Provider;
import com.google.inject.Provides;
import com.google.inject.matcher.Matchers;
import de.skuzzle.inject.async.guice.DefaultBinding;
import de.skuzzle.inject.async.guice.GuiceAsync;
import de.skuzzle.inject.async.schedule.DefaultExceptionHandler;
import de.skuzzle.inject.async.schedule.ExceptionHandler;
import de.skuzzle.inject.async.schedule.ExecutionContext;
import de.skuzzle.inject.async.schedule.MapBasedScope;
import de.skuzzle.inject.async.schedule.ScheduleProperties;
import de.skuzzle.inject.async.schedule.ScheduledContext;
import de.skuzzle.inject.async.schedule.ScheduledContextHolder;
import de.skuzzle.inject.async.schedule.SchedulerTypeListener;
import de.skuzzle.inject.async.schedule.SchedulingService;
import de.skuzzle.inject.async.schedule.SchedulingServiceImpl;
import de.skuzzle.inject.async.schedule.SpiTriggerStrategyRegistryImpl;
import de.skuzzle.inject.async.schedule.TriggerStrategyRegistry;
import de.skuzzle.inject.async.schedule.annotation.ExecutionScope;
import de.skuzzle.inject.async.schedule.annotation.ScheduledScope;
import de.skuzzle.inject.proxy.ScopedProxyBinder;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import javax.inject.Singleton;

public final class ScheduleModule
extends AbstractModule {
    private final ScheduleProperties scheduleProperties;

    public ScheduleModule(GuiceAsync principal, ScheduleProperties scheduleProperties) {
        Preconditions.checkArgument((principal != null ? 1 : 0) != 0, (Object)"instantiating this module is not allowed. Use the class GuiceAsync to enable asynchronous method support.");
        Preconditions.checkArgument((scheduleProperties != null ? 1 : 0) != 0, (Object)"scheduleProperties must not be null");
        this.scheduleProperties = scheduleProperties;
    }

    protected void configure() {
        this.bind(TriggerStrategyRegistry.class).to(SpiTriggerStrategyRegistryImpl.class).in(Singleton.class);
        SchedulingServiceImpl schedulingService = new SchedulingServiceImpl(this.scheduleProperties, (javax.inject.Provider<Injector>)this.getProvider(Injector.class), (javax.inject.Provider<TriggerStrategyRegistry>)this.getProvider(TriggerStrategyRegistry.class));
        this.bind(SchedulingService.class).toInstance((Object)schedulingService);
        SchedulerTypeListener scheduleListener = new SchedulerTypeListener(schedulingService);
        this.requestInjection(scheduleListener);
        this.bindListener(Matchers.any(), scheduleListener);
        Provider executionMap = () -> ScheduledContextHolder.getContext().getExecution().getProperties();
        this.bindScope(ExecutionScope.class, MapBasedScope.withMapSupplier((Provider<Map<String, Object>>)executionMap));
        Provider scheduledMap = () -> ScheduledContextHolder.getContext().getProperties();
        this.bindScope(ScheduledScope.class, MapBasedScope.withMapSupplier((Provider<Map<String, Object>>)scheduledMap));
        ScopedProxyBinder.using((Binder)this.binder()).bind(ScheduledContext.class).toProvider(ScheduledContextHolder::getContext);
        ScopedProxyBinder.using((Binder)this.binder()).bind(ExecutionContext.class).toProvider(() -> ScheduledContextHolder.getContext().getExecution());
    }

    @Provides
    @Singleton
    @DefaultBinding
    ScheduledExecutorService provideScheduler(@DefaultBinding ThreadFactory threadFactory) {
        int cores = Runtime.getRuntime().availableProcessors();
        return Executors.newScheduledThreadPool(cores, threadFactory);
    }

    @Provides
    @Singleton
    @DefaultBinding
    ExceptionHandler provideDefaultExceptionHandler() {
        return new DefaultExceptionHandler();
    }
}

