/*
 * Decompiled with CFR 0.152.
 */
package de.skuzzle.inject.async.schedule;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import de.skuzzle.inject.async.schedule.ExecutionContext;
import de.skuzzle.inject.async.schedule.ExecutionContextImpl;
import de.skuzzle.inject.async.schedule.ScheduledContext;
import de.skuzzle.inject.async.schedule.ScheduledContextHolder;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ScheduledContextImpl
implements ScheduledContext {
    private static final Logger LOG = LoggerFactory.getLogger(ScheduledContextImpl.class);
    private final Object executionContextLock;
    private final Method method;
    private final Object self;
    private final Map<String, Object> beanMap;
    private final ThreadLocal<ExecutionContextImpl> execution;
    private volatile int executionCount;
    private final Object futureLock;
    private volatile Future<?> future;

    public ScheduledContextImpl(Method method, Object self) {
        this.method = method;
        this.self = self;
        this.executionContextLock = new Object();
        this.futureLock = new Object();
        this.beanMap = new HashMap<String, Object>();
        this.execution = new ThreadLocal();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancel(boolean mayInterrupt) {
        Object object = this.futureLock;
        synchronized (object) {
            this.checkFutureSet();
            LOG.debug("Cancel called on ScheduledContext: {}", (Object)this);
            this.future.cancel(mayInterrupt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isCancelled() {
        Object object = this.futureLock;
        synchronized (object) {
            this.checkFutureSet();
            return this.future.isCancelled();
        }
    }

    private void setFuture(Future<?> future) {
        Preconditions.checkArgument((future != null ? 1 : 0) != 0, (Object)"future must not be null");
        this.future = future;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateFuture(Supplier<Future<?>> futureSupplier) {
        Preconditions.checkArgument((futureSupplier != null ? 1 : 0) != 0, (Object)"futureSupplier must not be null");
        Object object = this.futureLock;
        synchronized (object) {
            this.setFuture(futureSupplier.get());
        }
    }

    private void checkFutureSet() {
        Preconditions.checkState((this.future != null ? 1 : 0) != 0, (Object)"setFuture has not been called. There might be something wrong with the TriggerStrategy implementation.");
    }

    @Override
    public Method getMethod() {
        return this.method;
    }

    @Override
    public Object getSelf() {
        return this.self;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void beginNewExecution() {
        ExecutionContextImpl executionContext;
        Object object = this.executionContextLock;
        synchronized (object) {
            executionContext = new ExecutionContextImpl(this.method, this.executionCount++);
        }
        this.execution.set(executionContext);
        ScheduledContextHolder.push(this);
    }

    void finishExecution() {
        ScheduledContextHolder.pop();
        ExecutionContext activeContext = this.execution.get();
        Preconditions.checkState((activeContext != null ? 1 : 0) != 0, (Object)"there is no active ExecutionContext");
        this.execution.set(null);
    }

    @Override
    public int getExecutionCount() {
        return this.executionCount;
    }

    @Override
    public ExecutionContextImpl getExecution() {
        ExecutionContextImpl activeContext = this.execution.get();
        Preconditions.checkState((activeContext != null ? 1 : 0) != 0, (Object)"there is no active ExecutionContext");
        return activeContext;
    }

    @Override
    public Map<String, Object> getProperties() {
        return this.beanMap;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("executionCount", this.executionCount).add("method", (Object)this.method).add("self", this.self).add("properties", this.beanMap).toString();
    }
}

