/*
 * Decompiled with CFR 0.152.
 */
package de.skuzzle.inject.async.schedule;

import com.google.inject.Injector;
import com.google.inject.Key;
import de.skuzzle.inject.async.guice.Keys;
import de.skuzzle.inject.async.schedule.Annotations;
import de.skuzzle.inject.async.schedule.ExceptionHandler;
import de.skuzzle.inject.async.schedule.InjectedMethodInvocation;
import de.skuzzle.inject.async.schedule.LockableRunnable;
import de.skuzzle.inject.async.schedule.Runnables;
import de.skuzzle.inject.async.schedule.ScheduleProperties;
import de.skuzzle.inject.async.schedule.ScheduledContext;
import de.skuzzle.inject.async.schedule.ScheduledContextImpl;
import de.skuzzle.inject.async.schedule.SchedulingService;
import de.skuzzle.inject.async.schedule.TriggerStrategy;
import de.skuzzle.inject.async.schedule.TriggerStrategyRegistry;
import de.skuzzle.inject.async.schedule.annotation.Scheduled;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ScheduledExecutorService;
import javax.inject.Provider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SchedulingServiceImpl
implements SchedulingService {
    private static final Logger LOG = LoggerFactory.getLogger(SchedulingServiceImpl.class);
    private final ScheduleProperties scheduleProperties;
    private final Provider<Injector> injector;
    private final Provider<TriggerStrategyRegistry> registry;
    private final Collection<ManuallyStarted> manuallyStarted;

    SchedulingServiceImpl(ScheduleProperties scheduleProperties, Provider<Injector> injector, Provider<TriggerStrategyRegistry> registry) {
        this.scheduleProperties = scheduleProperties;
        this.injector = injector;
        this.registry = registry;
        this.manuallyStarted = new ArrayList<ManuallyStarted>();
    }

    @Override
    public void scheduleMemberMethod(Method method, Object self) {
        this.scheduleMethod(method, self);
    }

    @Override
    public void scheduleStaticMethod(Method method) {
        this.scheduleMethod(method, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startManualScheduling() {
        Collection<ManuallyStarted> collection = this.manuallyStarted;
        synchronized (collection) {
            this.manuallyStarted.forEach(ManuallyStarted::scheduleNow);
            this.manuallyStarted.clear();
        }
    }

    private void scheduleMethod(Method method, Object self) {
        if (!method.isAnnotationPresent(Scheduled.class)) {
            return;
        }
        Annotation trigger = Annotations.findTriggerAnnotation(method);
        LOG.trace("Method '{}' is elligible for scheduling. Trigger is: {}", (Object)method, (Object)trigger);
        Key<? extends ScheduledExecutorService> key = Keys.getSchedulerKey(method);
        Key<? extends ExceptionHandler> handlerKey = Keys.getExceptionHandler(method);
        LOG.trace("Scheduler key is: {}, ExceptionHandler key is: {}", key, handlerKey);
        ScheduledExecutorService scheduler = (ScheduledExecutorService)((Injector)this.injector.get()).getInstance(key);
        ExceptionHandler handler = (ExceptionHandler)((Injector)this.injector.get()).getInstance(handlerKey);
        TriggerStrategy strategy = ((TriggerStrategyRegistry)this.registry.get()).getStrategyFor(trigger);
        LOG.trace("Using trigger strategy: {}", (Object)strategy);
        ScheduledContextImpl context = new ScheduledContextImpl(method, self);
        InjectedMethodInvocation invocation = InjectedMethodInvocation.forMethod(method, self, (Injector)this.injector.get());
        LockableRunnable runnable = Runnables.createLockedRunnableStack(invocation, context, handler);
        if (this.mustStartManually(method)) {
            LOG.debug("Method '{}' is marked to be scheduled manually", (Object)method);
            this.manuallyStarted.add(new ManuallyStarted(context, scheduler, runnable, strategy));
        } else {
            strategy.schedule(context, scheduler, runnable);
        }
    }

    private boolean mustStartManually(Method method) {
        return !this.scheduleProperties.isAutoSchedulingEnabled() || method.isAnnotationPresent(de.skuzzle.inject.async.schedule.annotation.ManuallyStarted.class);
    }

    private static class ManuallyStarted {
        private final ScheduledContext context;
        private final ScheduledExecutorService scheduler;
        private final LockableRunnable runnable;
        private final TriggerStrategy strategy;

        ManuallyStarted(ScheduledContext context, ScheduledExecutorService scheduler, LockableRunnable runnable, TriggerStrategy strategy) {
            this.context = context;
            this.scheduler = scheduler;
            this.runnable = runnable;
            this.strategy = strategy;
        }

        public void scheduleNow() {
            this.strategy.schedule(this.context, this.scheduler, this.runnable);
        }
    }
}

