/*
 * Decompiled with CFR 0.152.
 */
package de.skuzzle.inject.async.schedule.trigger;

import com.cronutils.model.time.ExecutionTime;
import com.google.common.base.MoreObjects;
import de.skuzzle.inject.async.schedule.LockableRunnable;
import de.skuzzle.inject.async.schedule.ScheduledContext;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CronScheduler {
    private static final Logger LOG = LoggerFactory.getLogger(CronScheduler.class);
    private final Runnable invocation;
    private final ScheduledExecutorService executor;
    private final ExecutionTime executionTime;
    private final ScheduledContext context;
    private ZonedDateTime expectedNextExecution = null;

    private CronScheduler(ScheduledContext context, Runnable invocation, ScheduledExecutorService executor, ExecutionTime executionTime) {
        this.context = context;
        this.invocation = invocation;
        this.executor = executor;
        this.executionTime = executionTime;
    }

    static CronScheduler createWith(ScheduledContext context, Runnable invocation, ScheduledExecutorService scheduler, ExecutionTime executionTime) {
        return new CronScheduler(context, invocation, scheduler, executionTime);
    }

    public void start() {
        this.scheduleNextExecution();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleNextExecution() {
        LOG.debug("Scheduling next invocation of {}", (Object)this.invocation);
        long delayUntilNextExecution = this.millisUntilNextExecution();
        LockableRunnable lockedRunnable = this.createRunnableForNextExecution();
        try {
            this.context.updateFuture(() -> this.executor.schedule(lockedRunnable, delayUntilNextExecution, TimeUnit.MILLISECONDS));
        }
        finally {
            lockedRunnable.release();
        }
    }

    private LockableRunnable createRunnableForNextExecution() {
        return LockableRunnable.locked(() -> {
            this.scheduleNextExecution();
            LOG.debug("Executing actual invocation: {}", (Object)this.invocation);
            this.invocation.run();
        });
    }

    private synchronized long millisUntilNextExecution() {
        ZonedDateTime now = ZonedDateTime.now();
        ZonedDateTime currentExecution = this.expectedExecutionTimeOrElse(now);
        long inaccuracy = ChronoUnit.MILLIS.between(currentExecution, now);
        LOG.trace("cron scheduler inaccuracy: {} ms", (Object)inaccuracy);
        ZonedDateTime nextExecution = (ZonedDateTime)this.executionTime.nextExecution(currentExecution).orElseThrow(() -> new IllegalStateException("Could not determine next execution time"));
        long inaccuratDelayUntilNextExecution = ChronoUnit.MILLIS.between(currentExecution, nextExecution);
        long accurateDelay = inaccuratDelayUntilNextExecution - inaccuracy;
        this.expectNextExecutionAt(nextExecution);
        LOG.trace("accurate delay until next execution: {} ms (from '{}' to '{}')", new Object[]{accurateDelay, currentExecution, nextExecution});
        return accurateDelay;
    }

    private ZonedDateTime expectedExecutionTimeOrElse(ZonedDateTime now) {
        return this.expectedNextExecution == null ? now : this.expectedNextExecution;
    }

    private void expectNextExecutionAt(ZonedDateTime date) {
        this.expectedNextExecution = date;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("invocation", (Object)this.invocation).add("context", (Object)this.context).add("expectedNextExecution", (Object)this.expectedNextExecution).toString();
    }
}

