/*
 * Decompiled with CFR 0.152.
 */
package de.skuzzle.inject.async.schedule.trigger;

import com.cronutils.model.Cron;
import com.cronutils.model.definition.CronDefinition;
import com.cronutils.model.definition.CronDefinitionBuilder;
import com.cronutils.model.time.ExecutionTime;
import com.cronutils.parser.CronParser;
import com.google.common.base.Preconditions;
import de.skuzzle.inject.async.schedule.LockableRunnable;
import de.skuzzle.inject.async.schedule.ScheduledContext;
import de.skuzzle.inject.async.schedule.TriggerStrategy;
import de.skuzzle.inject.async.schedule.annotation.CronTrigger;
import de.skuzzle.inject.async.schedule.annotation.CronType;
import de.skuzzle.inject.async.schedule.trigger.CronScheduler;
import java.lang.reflect.Method;
import java.util.concurrent.ScheduledExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CronTriggerStrategy
implements TriggerStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(CronTriggerStrategy.class);

    public Class<CronTrigger> getTriggerType() {
        return CronTrigger.class;
    }

    @Override
    public void schedule(ScheduledContext context, ScheduledExecutorService executor, LockableRunnable runnable) {
        Method method = context.getMethod();
        CronTrigger trigger = method.getAnnotation(this.getTriggerType());
        Preconditions.checkArgument((trigger != null ? 1 : 0) != 0, (String)"Method '%s' not annotated with @CronTrigger", (Object)method);
        LOG.debug("Initially scheduling method '{}' on '{}' with trigger: {}", new Object[]{method, context.getSelf(), trigger});
        CronType cronType = trigger.cronType();
        CronDefinition cronDefinition = CronDefinitionBuilder.instanceDefinitionFor((com.cronutils.model.CronType)cronType.getType());
        CronParser parser = new CronParser(cronDefinition);
        Cron cron = parser.parse(trigger.value());
        ExecutionTime execTime = ExecutionTime.forCron((Cron)cron);
        CronScheduler.createWith(context, runnable.release(), executor, execTime).start();
    }
}

