/*
 * Decompiled with CFR 0.152.
 */
package de.skuzzle.inject.async.schedule.trigger;

import com.google.common.base.Preconditions;
import de.skuzzle.inject.async.schedule.LockableRunnable;
import de.skuzzle.inject.async.schedule.ScheduledContext;
import de.skuzzle.inject.async.schedule.TriggerStrategy;
import de.skuzzle.inject.async.schedule.annotation.DelayedTrigger;
import java.lang.reflect.Method;
import java.util.concurrent.ScheduledExecutorService;

public class DelayedTriggerStrategy
implements TriggerStrategy {
    public Class<DelayedTrigger> getTriggerType() {
        return DelayedTrigger.class;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void schedule(ScheduledContext context, ScheduledExecutorService executor, LockableRunnable runnable) {
        Method method = context.getMethod();
        DelayedTrigger trigger = method.getAnnotation(this.getTriggerType());
        Preconditions.checkArgument((trigger != null ? 1 : 0) != 0, (String)"Method '%s' not annotated with @DelayedTrigger", (Object)method);
        try {
            context.updateFuture(() -> executor.schedule(runnable, trigger.value(), trigger.timeUnit()));
        }
        finally {
            runnable.release();
        }
    }
}

