/*
 * Decompiled with CFR 0.152.
 */
package de.skuzzle.jeve;

import de.skuzzle.jeve.Listener;
import de.skuzzle.jeve.ListenerStore;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public class Event<T, L extends Listener> {
    private final T source;
    private boolean handled;
    private final Class<L> listenerClass;
    private ListenerStore store;
    private boolean prevented;
    private Map<String, Object> properties;

    public Event(T source, Class<L> listenerClass) {
        if (source == null) {
            throw new IllegalArgumentException("source is null");
        }
        if (listenerClass == null) {
            throw new IllegalArgumentException("listenerClass is null");
        }
        this.source = source;
        this.listenerClass = listenerClass;
        this.handled = false;
    }

    public Map<String, Object> getProperties() {
        if (this.properties == null) {
            this.properties = new HashMap<String, Object>();
        }
        return this.properties;
    }

    public <E> Optional<E> getValue(String key) {
        if (this.properties == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.getProperties().get(key));
    }

    public <E> Optional<E> getValueAs(String key, Class<E> type) {
        if (this.properties == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(type.cast(this.getProperties().get(key)));
    }

    public void setValue(String key, Object value) {
        this.getProperties().put(key, value);
    }

    public T getSource() {
        return this.source;
    }

    public boolean isPrevented() {
        return this.prevented;
    }

    public void setPrevented(boolean prevented) {
        this.prevented = prevented;
    }

    public Class<L> getListenerClass() {
        return this.listenerClass;
    }

    public void stopNotifying(L listener) {
        this.getListenerStore().remove(this.getListenerClass(), listener);
    }

    protected ListenerStore getListenerStore() {
        if (this.store == null) {
            throw new IllegalStateException("Event is not currently dispatched");
        }
        return this.store;
    }

    public void setListenerStore(ListenerStore store) {
        if (this.store == null) {
            this.store = store;
        }
    }

    public boolean isHandled() {
        return this.handled;
    }

    public void setHandled(boolean isHandled) {
        this.handled = isHandled;
    }
}

