/*
 * Decompiled with CFR 0.152.
 */
package de.skuzzle.jeve;

import de.skuzzle.jeve.Event;
import de.skuzzle.jeve.EventProvider;
import de.skuzzle.jeve.EventStack;
import de.skuzzle.jeve.ExceptionCallback;
import de.skuzzle.jeve.Listener;
import de.skuzzle.jeve.SequentialEvent;
import de.skuzzle.jeve.SuppressedEvent;
import java.util.Optional;
import java.util.function.BiConsumer;

public final class EventStackHelper {
    private EventStackHelper() {
    }

    public static <L extends Listener, E extends Event<?, L>> boolean checkPrevent(EventStack eventStack, E event, BiConsumer<L, E> bc, ExceptionCallback ec) {
        Optional<SequentialEvent<?, ?>> cause = eventStack.preventDispatch(event.getListenerClass());
        if (cause.isPresent()) {
            event.setPrevented(true);
            cause.get().addSuppressedEvent(new SuppressedEventImpl<L, E>(event, ec, bc));
            return true;
        }
        return false;
    }

    static class SuppressedEventImpl<L extends Listener, E extends Event<?, L>>
    implements SuppressedEvent {
        private final E event;
        private final ExceptionCallback ec;
        private final BiConsumer<L, E> consumer;
        private boolean dispatched;

        SuppressedEventImpl(E event, ExceptionCallback ec, BiConsumer<L, E> consumer) {
            this.event = event;
            this.ec = ec;
            this.consumer = consumer;
        }

        public Class<L> getListenerClass() {
            return ((Event)this.event).getListenerClass();
        }

        public E getEvent() {
            return this.event;
        }

        @Override
        public void redispatch(EventProvider<?> provider) {
            if (!this.dispatched) {
                this.dispatched = true;
                provider.dispatch(this.event, this.consumer, this.ec);
            }
        }

        public int hashCode() {
            return this.event.hashCode();
        }

        public boolean equals(Object obj) {
            return obj == this || obj instanceof SuppressedEvent && this.event.equals(((SuppressedEvent)obj).getEvent());
        }
    }
}

