/*
 * Decompiled with CFR 0.152.
 */
package de.skuzzle.jeve;

import de.skuzzle.jeve.ExceptionCallback;
import de.skuzzle.jeve.invoke.FailedEventInvocation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public final class FailureCollector
implements ExceptionCallback,
Iterable<FailedEventInvocation> {
    private final Object mutex = new Object();
    private List<FailedEventInvocation> failedEvents;
    private final ExceptionCallback delegate;

    private FailureCollector(ExceptionCallback delegate) {
        this.delegate = delegate;
    }

    public static FailureCollector delegatingTo(ExceptionCallback ec) {
        if (ec == null) {
            throw new IllegalArgumentException("ec is null");
        }
        return new FailureCollector(ec);
    }

    public static FailureCollector create() {
        return new FailureCollector(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<FailedEventInvocation> getFailedInvocations() {
        Object object = this.mutex;
        synchronized (object) {
            if (this.failedEvents == null) {
                return Collections.emptyList();
            }
            return Collections.unmodifiableList(this.failedEvents);
        }
    }

    @Override
    public Iterator<FailedEventInvocation> iterator() {
        return this.getFailedInvocations().iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void exception(FailedEventInvocation invocation) {
        Object object = this.mutex;
        synchronized (object) {
            if (this.failedEvents == null) {
                this.failedEvents = new ArrayList<FailedEventInvocation>();
            }
            this.failedEvents.add(invocation);
        }
        if (this.delegate != null) {
            this.delegate.exception(invocation);
        }
    }
}

