/*
 * Decompiled with CFR 0.152.
 */
package de.skuzzle.jeve;

import de.skuzzle.jeve.Event;
import de.skuzzle.jeve.EventStack;
import de.skuzzle.jeve.Listener;
import de.skuzzle.jeve.SuppressedEvent;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SequentialEvent<T, L extends Listener>
extends Event<T, L> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SequentialEvent.class);
    private Set<Class<?>> prevent;
    private Set<SuppressedEvent> suppressedEvents;
    private EventStack eventStack;
    private Optional<Event<?, ?>> cause = Optional.empty();

    public SequentialEvent(T source, Class<L> listenerClass) {
        super(source, listenerClass);
    }

    public void setEventStack(EventStack eventStack) {
        if (this.eventStack == null) {
            this.eventStack = eventStack;
            this.cause = eventStack.peek();
        }
    }

    public Optional<Event<?, ?>> getCause() {
        return this.cause;
    }

    public Optional<EventStack> getEventStack() {
        return Optional.ofNullable(this.eventStack);
    }

    public void addSuppressedEvent(SuppressedEvent e) {
        if (e == null) {
            throw new IllegalArgumentException("e is null");
        }
        if (this.suppressedEvents == null) {
            this.suppressedEvents = new HashSet<SuppressedEvent>();
        }
        this.suppressedEvents.add(e);
    }

    public Set<SuppressedEvent> getSuppressedEvents() {
        if (this.suppressedEvents == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(this.suppressedEvents);
    }

    public <E extends Listener> void preventCascade(Class<E> listenerClass) {
        if (listenerClass == null) {
            throw new IllegalArgumentException("listenerClass is null");
        }
        if (this.eventStack != null) {
            LOGGER.warn("'preventCascade' has been called on {} for listener class {} while the event was being dispatched. preventCascade must be called before dispatching the event.", (Object)this.getClass().getSimpleName(), (Object)this.getListenerClass().getSimpleName());
            return;
        }
        if (this.prevent == null) {
            this.prevent = new HashSet();
        }
        this.prevent.add(listenerClass);
    }

    public void preventCascade() {
        this.preventCascade(this.getListenerClass());
    }

    public Set<Class<?>> getPrevented() {
        if (this.prevent == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(this.prevent);
    }
}

