/*
 * Decompiled with CFR 0.152.
 */
package de.skuzzle.jeve.annotation;

import de.skuzzle.jeve.Event;
import de.skuzzle.jeve.Listener;
import de.skuzzle.jeve.annotation.ListenerInterface;
import de.skuzzle.jeve.annotation.ListenerKind;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Messager;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.NoType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;

@SupportedAnnotationTypes(value={"de.skuzzle.jeve.annotation.ListenerInterface"})
public class ListenerAnnotationProcessor
extends AbstractProcessor {
    private static final String EXPECTED_TYPE = "Listening method '%s' must return %s in order to conform to ListenerKind %s";
    private static final String ILLEGAL_PARAMETER = "Listening method '%s' must have a single parameter of type 'Event'";
    private static final String ILLEGAL_EXCEPTION = "Listening method '%s' can not throw checked exception";
    private static final String EMPTY_LISTENER = "Listener '%s' does not declare any listening methods";
    private static final String INTERFACE_ONLY = "@ListenerInterface only supported on interface types";
    private static final String MISSING_INHERITANCE = "@ListenerInterface '%s' must extend de.skuzzle.jeve.Listener";
    private static final String TAGGING_NOT_EMPTY = "Tagging listeners must be empty";

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        Messager msg = this.processingEnv.getMessager();
        Set<? extends Element> elements = roundEnv.getElementsAnnotatedWith(ListenerInterface.class);
        for (Element element : elements) {
            if (element.getKind() != ElementKind.INTERFACE) {
                msg.printMessage(Diagnostic.Kind.ERROR, INTERFACE_ONLY, element);
            }
            this.checkInheritance(element);
            ListenerInterface anno = element.getAnnotation(ListenerInterface.class);
            ListenerKind kind = anno.value();
            List members = element.getEnclosedElements().stream().filter(m -> m instanceof ExecutableElement).map(m -> (ExecutableElement)m).collect(Collectors.toList());
            if (kind == ListenerKind.TAGGING) {
                if (members.isEmpty()) continue;
                msg.printMessage(Diagnostic.Kind.ERROR, TAGGING_NOT_EMPTY, element);
                continue;
            }
            if (members.isEmpty()) {
                msg.printMessage(Diagnostic.Kind.WARNING, EMPTY_LISTENER, element);
                continue;
            }
            for (ExecutableElement member : members) {
                this.checkReturnValue(member, kind);
                this.checkParameter(member);
                this.checkThrown(member);
            }
        }
        return true;
    }

    private void checkReturnValue(ExecutableElement member, ListenerKind expectedKind) {
        Types types = this.processingEnv.getTypeUtils();
        Messager msg = this.processingEnv.getMessager();
        NoType voidPrim = types.getNoType(TypeKind.VOID);
        TypeMirror ret = member.getReturnType();
        switch (expectedKind) {
            case NORMAL: {
                if (types.isSameType(ret, voidPrim)) break;
                msg.printMessage(Diagnostic.Kind.ERROR, String.format(EXPECTED_TYPE, new Object[]{member.getSimpleName(), "'void'", expectedKind}), member);
                break;
            }
            case TAGGING: {
                assert (false) : "should not be reachable";
                break;
            }
        }
    }

    private void checkInheritance(Element parent) {
        Messager msg = this.processingEnv.getMessager();
        Types types = this.processingEnv.getTypeUtils();
        Elements elements = this.processingEnv.getElementUtils();
        TypeMirror listenerType = elements.getTypeElement(Listener.class.getName()).asType();
        if (!types.isSubtype(parent.asType(), listenerType)) {
            msg.printMessage(Diagnostic.Kind.ERROR, String.format(MISSING_INHERITANCE, parent.getSimpleName()), parent);
        }
    }

    private void checkParameter(ExecutableElement member) {
        Types types = this.processingEnv.getTypeUtils();
        Messager msg = this.processingEnv.getMessager();
        List<? extends VariableElement> params = member.getParameters();
        if (params.size() != 1) {
            msg.printMessage(Diagnostic.Kind.ERROR, String.format(ILLEGAL_PARAMETER, member.getSimpleName()), member);
            return;
        }
        Elements elements = this.processingEnv.getElementUtils();
        VariableElement param = params.iterator().next();
        TypeElement eventType = elements.getTypeElement(Event.class.getName());
        TypeElement listenerType = elements.getTypeElement(Listener.class.getName());
        DeclaredType listenerMirror = types.getDeclaredType(listenerType, new TypeMirror[0]);
        DeclaredType eType = types.getDeclaredType(eventType, types.getWildcardType(null, null), types.getWildcardType(listenerMirror, null));
        if (!types.isSubtype(param.asType(), eType)) {
            msg.printMessage(Diagnostic.Kind.ERROR, String.format(ILLEGAL_PARAMETER, member.getSimpleName()), param);
        }
    }

    private void checkThrown(ExecutableElement member) {
        Types types = this.processingEnv.getTypeUtils();
        Messager msg = this.processingEnv.getMessager();
        List<? extends TypeMirror> thrown = member.getThrownTypes();
        TypeMirror runtimeEx = this.processingEnv.getElementUtils().getTypeElement(RuntimeException.class.getName()).asType();
        for (TypeMirror typeMirror : thrown) {
            if (types.isSubtype(typeMirror, runtimeEx)) continue;
            msg.printMessage(Diagnostic.Kind.ERROR, String.format(ILLEGAL_EXCEPTION, member.getSimpleName()), member);
            return;
        }
    }
}

