/*
 * Decompiled with CFR 0.152.
 */
package de.skuzzle.jeve.builder;

import de.skuzzle.jeve.EventProvider;
import de.skuzzle.jeve.ListenerStore;
import de.skuzzle.jeve.builder.AsyncProviderConfiguratorImpl;
import de.skuzzle.jeve.builder.CustomConfigurator;
import de.skuzzle.jeve.builder.EventProviderConfigurator;
import de.skuzzle.jeve.builder.ProviderConfiguratorImpl;
import de.skuzzle.jeve.providers.AWTEventProvider;
import de.skuzzle.jeve.providers.AsynchronousEventProvider;
import de.skuzzle.jeve.providers.ParallelEventProvider;
import de.skuzzle.jeve.providers.SequentialEventProvider;
import de.skuzzle.jeve.providers.UnrollingEventProvider;
import java.util.function.Function;
import java.util.function.Supplier;

class ProviderChooserImpl<S extends ListenerStore>
implements EventProviderConfigurator.ProviderChooser<S> {
    private final Supplier<S> storeSupplier;

    ProviderChooserImpl(Supplier<S> storeSupplier) {
        if (storeSupplier == null) {
            throw new IllegalArgumentException("storeSupplier is null");
        }
        this.storeSupplier = storeSupplier;
    }

    @Override
    public <C, E extends EventProvider<S>> EventProviderConfigurator.Chainable<C, E> useCustomProvider(final CustomConfigurator<S, C, E> configurator) {
        if (configurator == null) {
            throw new IllegalArgumentException("configurator is null");
        }
        return new EventProviderConfigurator.Chainable<C, E>(){

            @Override
            public C and() {
                return configurator.getConfigurator(ProviderChooserImpl.this.storeSupplier);
            }

            @Override
            public Supplier<E> createSupplier() {
                return () -> this.create();
            }

            @Override
            public E create() {
                return configurator.createNow(ProviderChooserImpl.this.storeSupplier);
            }
        };
    }

    private <E extends EventProvider<S>> EventProviderConfigurator.Chainable<EventProviderConfigurator.ProviderConfigurator<S, E>, E> synchronAnd(final Function<S, E> providerConstructor, final Supplier<S> storeSupplier) {
        return new EventProviderConfigurator.Chainable<EventProviderConfigurator.ProviderConfigurator<S, E>, E>(){

            @Override
            public EventProviderConfigurator.ProviderConfigurator<S, E> and() {
                return new ProviderConfiguratorImpl(providerConstructor, storeSupplier);
            }

            @Override
            public Supplier<E> createSupplier() {
                return () -> this.create();
            }

            @Override
            public E create() {
                return (EventProvider)providerConstructor.apply(storeSupplier.get());
            }
        };
    }

    private <E extends EventProvider<S>> EventProviderConfigurator.Chainable<EventProviderConfigurator.AsyncProviderConfigurator<S, E>, E> asynchronAnd(final Function<S, E> providerConstructor, final Supplier<S> storeSupplier) {
        return new EventProviderConfigurator.Chainable<EventProviderConfigurator.AsyncProviderConfigurator<S, E>, E>(){

            @Override
            public EventProviderConfigurator.AsyncProviderConfigurator<S, E> and() {
                return new AsyncProviderConfiguratorImpl(providerConstructor, storeSupplier);
            }

            @Override
            public Supplier<E> createSupplier() {
                return () -> this.create();
            }

            @Override
            public E create() {
                return (EventProvider)providerConstructor.apply(storeSupplier.get());
            }
        };
    }

    @Override
    public EventProviderConfigurator.Chainable<EventProviderConfigurator.ProviderConfigurator<S, SequentialEventProvider<S>>, SequentialEventProvider<S>> useSynchronousProvider() {
        Function<ListenerStore, SequentialEventProvider> ctor = SequentialEventProvider::new;
        return this.synchronAnd(ctor, this.storeSupplier);
    }

    @Override
    public EventProviderConfigurator.Chainable<EventProviderConfigurator.ProviderConfigurator<S, UnrollingEventProvider<S>>, UnrollingEventProvider<S>> useUnrollingProvider() {
        Function<ListenerStore, UnrollingEventProvider> ctor = UnrollingEventProvider::new;
        return this.synchronAnd(ctor, this.storeSupplier);
    }

    @Override
    public EventProviderConfigurator.Chainable<EventProviderConfigurator.AsyncProviderConfigurator<S, AsynchronousEventProvider<S>>, AsynchronousEventProvider<S>> useAsynchronousProvider() {
        Function<ListenerStore, AsynchronousEventProvider> ctor = AsynchronousEventProvider::new;
        return this.asynchronAnd(ctor, this.storeSupplier);
    }

    @Override
    public EventProviderConfigurator.Chainable<EventProviderConfigurator.AsyncProviderConfigurator<S, ParallelEventProvider<S>>, ParallelEventProvider<S>> useParallelProvider() {
        Function<ListenerStore, ParallelEventProvider> ctor = ParallelEventProvider::new;
        return this.asynchronAnd(ctor, this.storeSupplier);
    }

    @Override
    public EventProviderConfigurator.Chainable<EventProviderConfigurator.ProviderConfigurator<S, AWTEventProvider<S>>, AWTEventProvider<S>> useWaitingAWTEventProvider() {
        Function<ListenerStore, AWTEventProvider> ctor = store -> new AWTEventProvider<ListenerStore>((ListenerStore)store, true);
        return this.synchronAnd(ctor, this.storeSupplier);
    }

    @Override
    public EventProviderConfigurator.Chainable<EventProviderConfigurator.ProviderConfigurator<S, AWTEventProvider<S>>, AWTEventProvider<S>> useAsynchronAWTEventProvider() {
        Function<ListenerStore, AWTEventProvider> ctor = store -> new AWTEventProvider<ListenerStore>((ListenerStore)store, false);
        return this.synchronAnd(ctor, this.storeSupplier);
    }
}

