/*
 * Decompiled with CFR 0.152.
 */
package de.skuzzle.jeve.builder;

import de.skuzzle.jeve.EventProvider;
import de.skuzzle.jeve.ExceptionCallback;
import de.skuzzle.jeve.ListenerStore;
import de.skuzzle.jeve.builder.EventProviderConfigurator;
import de.skuzzle.jeve.providers.StatisticsEventProvider;
import java.util.function.Function;
import java.util.function.Supplier;

class ProviderConfiguratorImpl<S extends ListenerStore, E extends EventProvider<S>>
implements EventProviderConfigurator.ProviderConfigurator<S, E> {
    private final Function<S, E> providerConstructor;
    private final Supplier<S> storeSupplier;
    private Supplier<ExceptionCallback> ecSupplier;
    private boolean synchStore;

    ProviderConfiguratorImpl(Function<S, E> providerConstructor, Supplier<S> storeSupplier) {
        if (providerConstructor == null) {
            throw new IllegalArgumentException("providerSupplier is null");
        }
        if (storeSupplier == null) {
            throw new IllegalArgumentException("storeSupplier is null");
        }
        this.providerConstructor = providerConstructor;
        this.storeSupplier = storeSupplier;
    }

    ProviderConfiguratorImpl(Function<S, E> providerConstructor, Supplier<S> storeSupplier, Supplier<ExceptionCallback> ecSupplier, boolean synchronizeStore) {
        this.providerConstructor = providerConstructor;
        this.storeSupplier = storeSupplier;
        this.ecSupplier = ecSupplier;
        this.synchStore = synchronizeStore;
    }

    private E create() {
        ListenerStore store = this.synchStore ? ((ListenerStore)this.storeSupplier.get()).synchronizedView() : (ListenerStore)this.storeSupplier.get();
        EventProvider result = (EventProvider)this.providerConstructor.apply(store);
        if (this.ecSupplier != null) {
            result.setExceptionCallback(this.ecSupplier.get());
        }
        return (E)result;
    }

    @Override
    public EventProviderConfigurator.Chainable<EventProviderConfigurator.ProviderConfigurator<S, E>, E> exceptionCallBack(ExceptionCallback ec) {
        this.ecSupplier = () -> ec;
        return new EventProviderConfigurator.Chainable<EventProviderConfigurator.ProviderConfigurator<S, E>, E>(){

            @Override
            public EventProviderConfigurator.ProviderConfigurator<S, E> and() {
                return ProviderConfiguratorImpl.this;
            }

            @Override
            public E create() {
                return ProviderConfiguratorImpl.this.create();
            }
        };
    }

    @Override
    public EventProviderConfigurator.Chainable<EventProviderConfigurator.ProviderConfigurator<S, E>, E> exceptionCallBack(Supplier<ExceptionCallback> callBackSupplier) {
        if (callBackSupplier == null) {
            throw new IllegalArgumentException("callBackSupplier is null");
        }
        this.ecSupplier = callBackSupplier;
        return new EventProviderConfigurator.Chainable<EventProviderConfigurator.ProviderConfigurator<S, E>, E>(){

            @Override
            public EventProviderConfigurator.ProviderConfigurator<S, E> and() {
                return ProviderConfiguratorImpl.this;
            }

            @Override
            public E create() {
                return ProviderConfiguratorImpl.this.create();
            }
        };
    }

    @Override
    public EventProviderConfigurator.Chainable<EventProviderConfigurator.ProviderConfigurator<S, E>, E> synchronizeStore() {
        this.synchStore = true;
        return new EventProviderConfigurator.Chainable<EventProviderConfigurator.ProviderConfigurator<S, E>, E>(){

            @Override
            public EventProviderConfigurator.ProviderConfigurator<S, E> and() {
                return ProviderConfiguratorImpl.this;
            }

            @Override
            public E create() {
                return ProviderConfiguratorImpl.this.create();
            }
        };
    }

    @Override
    public EventProviderConfigurator.Final<StatisticsEventProvider<S, E>> statistics() {
        final Function<ListenerStore, StatisticsEventProvider> ctor = store -> {
            E provider = this.create();
            return new StatisticsEventProvider(provider);
        };
        return new EventProviderConfigurator.Final<StatisticsEventProvider<S, E>>(){

            @Override
            public Supplier<StatisticsEventProvider<S, E>> createSupplier() {
                return () -> this.create();
            }

            @Override
            public StatisticsEventProvider<S, E> create() {
                return (StatisticsEventProvider)ctor.apply(null);
            }
        };
    }
}

