/*
 * Decompiled with CFR 0.152.
 */
package de.skuzzle.jeve.invoke;

import de.skuzzle.jeve.AbortionException;
import de.skuzzle.jeve.Event;
import de.skuzzle.jeve.ExceptionCallback;
import de.skuzzle.jeve.Listener;
import de.skuzzle.jeve.invoke.EventInvocation;
import de.skuzzle.jeve.invoke.FailedEventInvocation;
import de.skuzzle.jeve.invoke.FailedEventInvocationImpl;
import java.util.Objects;
import java.util.function.BiConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class EventInvocationImpl<L extends Listener, E extends Event<?, L>>
implements EventInvocation {
    private static final Logger LOG = LoggerFactory.getLogger(EventInvocation.class);
    protected final E event;
    protected final ExceptionCallback ec;
    protected final L listener;
    protected final BiConsumer<L, E> consumer;

    EventInvocationImpl(E event, L listener, ExceptionCallback ec, BiConsumer<L, E> consumer) {
        this.event = event;
        this.listener = listener;
        this.ec = ec;
        this.consumer = consumer;
    }

    public int hashCode() {
        return Objects.hash(this.event, this.listener);
    }

    public boolean equals(Object obj) {
        EventInvocation other;
        return obj == this || obj instanceof EventInvocation && this.event.equals((other = (EventInvocation)obj).getEvent()) && this.listener.equals(other.getListener());
    }

    public E getEvent() {
        return this.event;
    }

    public L getListener() {
        return this.listener;
    }

    @Override
    public final void notifyListener() {
        try {
            this.consumer.accept(this.listener, this.event);
        }
        catch (AbortionException e) {
            throw e;
        }
        catch (RuntimeException e) {
            this.handleException(this.fail(e));
        }
    }

    @Override
    public FailedEventInvocation fail(Exception e) {
        return new FailedEventInvocationImpl<L, E>(this.event, this.listener, this.ec, this.consumer, e);
    }

    private void handleException(FailedEventInvocation inv) {
        try {
            this.ec.exception(inv);
        }
        catch (AbortionException abort) {
            throw abort;
        }
        catch (Exception ignore) {
            LOG.error("ExceptionCallback '{}' threw an exception", (Object)this.ec, (Object)ignore);
        }
    }
}

