/*
 * Decompiled with CFR 0.152.
 */
package de.skuzzle.jeve.providers;

import de.skuzzle.jeve.AbortionException;
import de.skuzzle.jeve.Event;
import de.skuzzle.jeve.ExceptionCallback;
import de.skuzzle.jeve.Listener;
import de.skuzzle.jeve.ListenerStore;
import de.skuzzle.jeve.providers.AbstractEventProvider;
import java.lang.reflect.InvocationTargetException;
import java.util.function.BiConsumer;
import javax.swing.SwingUtilities;

public class AWTEventProvider<S extends ListenerStore>
extends AbstractEventProvider<S> {
    private final boolean invokeNow;

    public AWTEventProvider(S store, boolean invokeNow) {
        super(store);
        this.invokeNow = invokeNow;
    }

    public boolean isInvokeNow() {
        return this.invokeNow;
    }

    @Override
    public <L extends Listener, E extends Event<?, L>> void dispatch(E event, BiConsumer<L, E> bc, ExceptionCallback ec) {
        this.checkDispatchArgs(event, bc, ec);
        if (this.invokeNow) {
            if (SwingUtilities.isEventDispatchThread()) {
                this.notifyListeners(event, bc, ec);
            } else {
                try {
                    SwingUtilities.invokeAndWait(() -> this.notifyListeners(event, bc, ec));
                }
                catch (InvocationTargetException e) {
                    if (e.getTargetException() instanceof AbortionException) {
                        throw (AbortionException)e.getTargetException();
                    }
                    throw new IllegalStateException(e);
                }
                catch (InterruptedException e) {
                    throw new AbortionException(e);
                }
            }
        } else {
            SwingUtilities.invokeLater(() -> this.notifyListeners(event, bc, ec));
        }
    }

    @Override
    public boolean canDispatch() {
        return true;
    }

    @Override
    protected boolean isImplementationSequential() {
        return true;
    }
}

