/*
 * Decompiled with CFR 0.152.
 */
package de.skuzzle.jeve.providers;

import de.skuzzle.jeve.DefaultDispatchable;
import de.skuzzle.jeve.Event;
import de.skuzzle.jeve.EventProvider;
import de.skuzzle.jeve.ExceptionCallback;
import de.skuzzle.jeve.Listener;
import de.skuzzle.jeve.ListenerStore;
import de.skuzzle.jeve.invoke.EventInvocation;
import de.skuzzle.jeve.invoke.FailedEventInvocation;
import java.util.Iterator;
import java.util.function.BiConsumer;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractEventProvider<S extends ListenerStore>
implements EventProvider<S> {
    private static final Logger LOGGER = LoggerFactory.getLogger(EventProvider.class);
    private final S store;
    protected ExceptionCallback exceptionHandler;
    protected final ExceptionCallback defaultHandler = new ExceptionCallback(){

        @Override
        public void exception(FailedEventInvocation invocation) {
            LOGGER.error("Listener threw an exception while being notified\nDetails\n    Listener: {}\n    Event: {}\n    Message: {}\n    Current Thread: {}\n    Stacktrace:\n", new Object[]{invocation.getListener(), invocation.getEvent(), invocation.getException().getMessage(), Thread.currentThread().getName(), invocation.getException()});
        }
    };

    public AbstractEventProvider(S store) {
        if (store == null) {
            throw new IllegalArgumentException("listenerStore is null");
        }
        this.store = store;
        this.exceptionHandler = this.defaultHandler;
    }

    @Override
    public S listeners() {
        return this.store;
    }

    @Override
    public <L extends Listener, E extends Event<?, L>> void dispatch(E event, BiConsumer<L, E> bc) {
        this.dispatch(event, bc, this.exceptionHandler);
    }

    @Override
    public <L extends Listener, E extends Event<?, L>> void dispatch(E event, BiConsumer<L, E> bc, ExceptionCallback ec) {
        this.checkDispatchArgs(event, bc, ec);
        if (this.canDispatch()) {
            this.notifyListeners(event, bc, ec);
        }
    }

    @Override
    public void dispatch(DefaultDispatchable event) {
        if (event == null) {
            throw new IllegalArgumentException("event is null");
        }
        event.defaultDispatch(this, this.exceptionHandler);
    }

    protected <L extends Listener, E extends Event<?, ?>> void checkDispatchArgs(E event, Object bc, ExceptionCallback ec) {
        if (event == null) {
            throw new IllegalArgumentException("event is null");
        }
        if (bc == null) {
            throw new IllegalArgumentException("bc is null");
        }
        if (ec == null) {
            throw new IllegalArgumentException("ec is null");
        }
    }

    @Override
    public synchronized void setExceptionCallback(ExceptionCallback callBack) {
        ExceptionCallback ec = callBack == null ? this.defaultHandler : callBack;
        this.exceptionHandler = ec;
    }

    protected <L extends Listener, E extends Event<?, L>> void notifyListeners(E event, BiConsumer<L, E> bc, ExceptionCallback ec) {
        Stream<L> listeners = this.listeners().get(event.getListenerClass());
        event.setListenerStore((ListenerStore)this.store);
        Iterator it = listeners.iterator();
        while (it.hasNext()) {
            Listener listener = (Listener)it.next();
            if (event.isHandled()) {
                return;
            }
            this.notifySingle(listener, event, bc, ec);
        }
    }

    protected <L extends Listener, E extends Event<?, L>> void notifySingle(L listener, E event, BiConsumer<L, E> bc, ExceptionCallback ec) {
        this.createInvocation(listener, event, bc, ec).notifyListener();
    }

    protected <L extends Listener, E extends Event<?, L>> EventInvocation createInvocation(L listener, E event, BiConsumer<L, E> bc, ExceptionCallback ec) {
        return EventInvocation.of(listener, event, bc, ec);
    }

    @Override
    public final boolean isSequential() {
        return this.store.isSequential() && this.isImplementationSequential();
    }

    protected abstract boolean isImplementationSequential();

    @Override
    public void close() {
        this.store.close();
    }

    public String toString() {
        return this.store.toString();
    }
}

