/*
 * Decompiled with CFR 0.152.
 */
package de.skuzzle.jeve.providers;

import de.skuzzle.jeve.Event;
import de.skuzzle.jeve.EventStack;
import de.skuzzle.jeve.Listener;
import de.skuzzle.jeve.SequentialEvent;
import java.io.PrintStream;
import java.util.Collection;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Optional;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class EventStackImpl
implements EventStack {
    private static final Logger LOGGER = LoggerFactory.getLogger(EventStackImpl.class);
    private final Deque<Event<?, ?>> stack = new LinkedList();

    @Override
    public void dumpStack() {
        LOGGER.debug("jeve event stack:");
        if (this.stack.isEmpty()) {
            LOGGER.debug("\t<empty>");
            return;
        }
        this.dumpInternal(e -> LOGGER.debug("\t{}:{}:{}", new Object[]{e.getSource(), e.getListenerClass().getSimpleName(), e}));
    }

    @Override
    public void dumpStack(PrintStream out) {
        if (out == null) {
            throw new IllegalArgumentException("out is null");
        }
        out.println("jeve event stack:");
        if (this.stack.isEmpty()) {
            out.println("\t<empty>");
            return;
        }
        this.dumpInternal(e -> out.printf("\t%s:%s:%s%n", e.getSource(), e.getListenerClass().getSimpleName(), e));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dumpInternal(Consumer<Event<?, ?>> c) {
        Deque<Event<?, ?>> deque = this.stack;
        synchronized (deque) {
            Iterator<Event<?, ?>> it = this.stack.iterator();
            it.forEachRemaining(c);
        }
    }

    @Override
    public Optional<Event<?, ?>> peek() {
        return this.stack.isEmpty() ? Optional.empty() : Optional.of(this.stack.peek());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <L extends Listener> void pushEvent(Event<?, L> event) {
        Deque<Event<?, ?>> deque = this.stack;
        synchronized (deque) {
            this.stack.push(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <L extends Listener> void popEvent(Event<?, L> expected) {
        Deque<Event<?, ?>> deque = this.stack;
        synchronized (deque) {
            Event<?, ?> actual = this.stack.pop();
            if (actual != expected) {
                throw new IllegalStateException(String.format("Unbalanced pop: expected '%s' but encountered '%s'", expected.getListenerClass(), actual));
            }
        }
    }

    @Override
    public boolean isActive(Event<?, ?> event) {
        return this.isActive(event.getListenerClass());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isAnyActive(Collection<? extends Class<? extends Listener>> c) {
        Deque<Event<?, ?>> deque = this.stack;
        synchronized (deque) {
            return this.stack.stream().anyMatch(event -> c.contains(event.getListenerClass()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isActive(Class<? extends Listener> listenerClass) {
        Deque<Event<?, ?>> deque = this.stack;
        synchronized (deque) {
            return this.stack.stream().anyMatch(event -> event.getListenerClass() == listenerClass);
        }
    }

    @Override
    public Optional<SequentialEvent<?, ?>> preventDispatch(Event<?, ?> event) {
        return this.preventDispatch(event.getListenerClass());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Optional<SequentialEvent<?, ?>> preventDispatch(Class<? extends Listener> listenerClass) {
        Deque<Event<?, ?>> deque = this.stack;
        synchronized (deque) {
            Iterator<Event<?, ?>> it = this.stack.descendingIterator();
            while (it.hasNext()) {
                SequentialEvent synchEvent;
                Event<?, ?> event = it.next();
                if (!(event instanceof SequentialEvent) || !(synchEvent = (SequentialEvent)event).getPrevented().contains(listenerClass)) continue;
                return Optional.of(synchEvent);
            }
            return Optional.empty();
        }
    }
}

