/*
 * Decompiled with CFR 0.152.
 */
package de.skuzzle.jeve.providers;

import de.skuzzle.jeve.Event;
import de.skuzzle.jeve.EventProvider;
import de.skuzzle.jeve.ExceptionCallback;
import de.skuzzle.jeve.Listener;
import de.skuzzle.jeve.ListenerStore;
import de.skuzzle.jeve.providers.AbstractEventProvider;
import de.skuzzle.jeve.providers.ExecutorAware;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParallelEventProvider<S extends ListenerStore>
extends AbstractEventProvider<S>
implements ExecutorAware {
    private static final Logger LOGGER = LoggerFactory.getLogger(EventProvider.class);
    private static final long TERMINATION_TIMEOUT = 2000L;
    private ExecutorService executor;

    public ParallelEventProvider(S store) {
        this(store, Executors.newCachedThreadPool());
    }

    public ParallelEventProvider(S store, ExecutorService executor) {
        super(store);
        if (executor == null) {
            throw new IllegalArgumentException("executor is null");
        }
        this.executor = executor;
    }

    @Override
    public void setExecutorService(ExecutorService executor) {
        if (executor == null) {
            throw new IllegalArgumentException("executor is null");
        }
        this.executor = executor;
    }

    @Override
    public <L extends Listener, E extends Event<?, L>> void dispatch(E event, BiConsumer<L, E> bc, ExceptionCallback ec) {
        this.checkDispatchArgs(event, bc, ec);
        if (!this.canDispatch()) {
            return;
        }
        Stream<L> listeners = this.listeners().get(event.getListenerClass());
        event.setListenerStore((ListenerStore)this.listeners());
        listeners.forEach(listener -> this.executor.execute(() -> this.notifySingle(listener, event, bc, ec)));
    }

    @Override
    public boolean canDispatch() {
        return !this.executor.isShutdown() && !this.executor.isTerminated();
    }

    @Override
    public void close() {
        super.close();
        this.executor.shutdownNow();
        try {
            this.executor.awaitTermination(2000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            LOGGER.error("ParallelEventProvider: Error while waiting for termination of executor", (Throwable)e);
        }
    }

    @Override
    protected boolean isImplementationSequential() {
        return false;
    }
}

