/*
 * Decompiled with CFR 0.152.
 */
package de.skuzzle.jeve.providers;

import de.skuzzle.jeve.Event;
import de.skuzzle.jeve.EventStack;
import de.skuzzle.jeve.EventStackHelper;
import de.skuzzle.jeve.ExceptionCallback;
import de.skuzzle.jeve.Listener;
import de.skuzzle.jeve.ListenerStore;
import de.skuzzle.jeve.SequentialEvent;
import de.skuzzle.jeve.providers.AbstractEventProvider;
import de.skuzzle.jeve.providers.EventStackImpl;
import java.util.Iterator;
import java.util.function.BiConsumer;
import java.util.stream.Stream;

public class SequentialEventProvider<S extends ListenerStore>
extends AbstractEventProvider<S> {
    private final EventStackImpl eventStack = new EventStackImpl();

    public SequentialEventProvider(S store) {
        super(store);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected <L extends Listener, E extends Event<?, L>> void notifyListeners(E event, BiConsumer<L, E> bc, ExceptionCallback ec) {
        if (EventStackHelper.checkPrevent(this.eventStack, event, bc, ec)) {
            return;
        }
        Stream<L> listeners = this.listeners().get(event.getListenerClass());
        try {
            event.setListenerStore((ListenerStore)this.listeners());
            if (event instanceof SequentialEvent) {
                ((SequentialEvent)event).setEventStack(this.eventStack);
            }
            this.eventStack.pushEvent(event);
            Iterator it = listeners.iterator();
            while (it.hasNext()) {
                Listener listener = (Listener)it.next();
                if (event.isHandled()) {
                    return;
                }
                this.notifySingle(listener, event, bc, ec);
            }
        }
        finally {
            this.eventStack.popEvent(event);
        }
    }

    public EventStack getEventStack() {
        return this.eventStack;
    }

    @Override
    public boolean canDispatch() {
        return true;
    }

    @Override
    protected boolean isImplementationSequential() {
        return true;
    }
}

