/*
 * Decompiled with CFR 0.152.
 */
package de.skuzzle.jeve.providers;

import de.skuzzle.jeve.DefaultDispatchable;
import de.skuzzle.jeve.Event;
import de.skuzzle.jeve.EventProvider;
import de.skuzzle.jeve.ExceptionCallback;
import de.skuzzle.jeve.Listener;
import de.skuzzle.jeve.ListenerStore;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;

public class StatisticsEventProvider<S extends ListenerStore, P extends EventProvider<S>>
implements EventProvider<S> {
    private final Map<Class<? extends Listener>, Integer> notifications;
    private final P wrapped;

    public StatisticsEventProvider(P wrapped) {
        if (wrapped == null) {
            throw new IllegalArgumentException("wrapped is null");
        }
        this.wrapped = wrapped;
        this.notifications = Collections.synchronizedMap(new HashMap());
    }

    private <K> void increment(Map<K, Integer> map, K key) {
        map.compute(key, (k, i) -> i == null ? 1 : i + 1);
    }

    public P getWrapped() {
        return this.wrapped;
    }

    public Map<Class<? extends Listener>, Integer> getNotificationStatistics() {
        return Collections.unmodifiableMap(this.notifications);
    }

    @Override
    public <L extends Listener, E extends Event<?, L>> void dispatch(E event, BiConsumer<L, E> bc) {
        if (event == null) {
            throw new IllegalArgumentException("event is null");
        }
        this.increment(this.notifications, event.getListenerClass());
        event.setListenerStore((ListenerStore)this.listeners());
        this.wrapped.dispatch(event, bc);
    }

    @Override
    public <L extends Listener, E extends Event<?, L>> void dispatch(E event, BiConsumer<L, E> bc, ExceptionCallback ec) {
        if (event == null) {
            throw new IllegalArgumentException("event is null");
        }
        this.increment(this.notifications, event.getListenerClass());
        event.setListenerStore((ListenerStore)this.listeners());
        this.wrapped.dispatch(event, bc, ec);
    }

    @Override
    public void dispatch(DefaultDispatchable event) {
        this.wrapped.dispatch(event);
    }

    @Override
    public void close() {
        this.wrapped.close();
        this.notifications.clear();
    }

    @Override
    public S listeners() {
        return this.wrapped.listeners();
    }

    @Override
    public boolean canDispatch() {
        return this.wrapped.canDispatch();
    }

    @Override
    public void setExceptionCallback(ExceptionCallback ec) {
        this.wrapped.setExceptionCallback(ec);
    }

    @Override
    public boolean isSequential() {
        return this.wrapped.isSequential();
    }
}

