/*
 * Decompiled with CFR 0.152.
 */
package de.skuzzle.jeve.stores;

import de.skuzzle.jeve.Listener;
import de.skuzzle.jeve.ListenerStore;
import de.skuzzle.jeve.annotation.ListenerInterface;
import de.skuzzle.jeve.annotation.ListenerKind;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractListenerStore
implements ListenerStore {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractListenerStore.class);
    protected static final int DEFAULT_SIZE_HINT = 8;

    protected abstract <T> List<T> createListenerList(int var1);

    protected final <T> List<T> createListenerList() {
        return this.createListenerList(8);
    }

    protected <T extends Listener> Collection<T> copyList(Class<T> listenerClass, Stream<Object> listeners, int sizeHint) {
        if (sizeHint == 0) {
            return Collections.emptyList();
        }
        return listeners.map(listenerClass::cast).collect(Collectors.toCollection(() -> new ArrayList(sizeHint)));
    }

    public <T extends Listener> void add(T listener) {
        HashSet<Class<? extends Listener>> toAdd = new HashSet<Class<? extends Listener>>();
        this.handleClass(listener.getClass(), toAdd);
        LOGGER.debug("{} will be registered for {}", toAdd);
        toAdd.forEach(listenerClass -> this.add(listenerClass, listener));
    }

    public <T extends Listener> void remove(T listener) {
        ArrayList<Class<? extends Listener>> toRemove = new ArrayList<Class<? extends Listener>>();
        this.handleClass(listener.getClass(), toRemove);
        toRemove.forEach(listenerClass -> this.remove(listenerClass, listener));
    }

    private void handleClass(Class<?> cls, Collection<Class<? extends Listener>> result) {
        if (cls == null) {
            return;
        }
        for (Class<?> interf : cls.getInterfaces()) {
            if (this.shouldAdd(interf)) {
                result.add(interf);
                continue;
            }
            this.handleClass(interf, result);
        }
        this.handleClass(cls.getSuperclass(), result);
    }

    private boolean shouldAdd(Class<?> cls) {
        ListenerInterface li;
        if (cls.isAnnotationPresent(ListenerInterface.class) && (li = cls.getAnnotation(ListenerInterface.class)).value() == ListenerKind.TAGGING) {
            return false;
        }
        return cls != Listener.class && Listener.class.isAssignableFrom(cls);
    }
}

