/*
 * Decompiled with CFR 0.152.
 */
package de.skuzzle.jeve.stores;

import de.skuzzle.jeve.Listener;
import de.skuzzle.jeve.ListenerStore;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Supplier;
import java.util.stream.Stream;

public abstract class AbstractSynchronizedListenerStore<T extends ListenerStore>
implements ListenerStore {
    private final ReadWriteLock lock;
    protected final T wrapped;

    public AbstractSynchronizedListenerStore(T wrapped) {
        if (wrapped == null) {
            throw new IllegalArgumentException("wrapped is null");
        }
        this.wrapped = wrapped;
        this.lock = new ReentrantReadWriteLock();
    }

    protected void modify(Transaction t) {
        try {
            this.lock.writeLock().lock();
            t.perform();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    protected <E> E read(Supplier<E> sup) {
        try {
            this.lock.readLock().lock();
            E e = sup.get();
            return e;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public abstract T synchronizedView();

    @Override
    public <L extends Listener> void add(Class<L> listenerClass, L listener) {
        this.modify(() -> this.wrapped.add(listenerClass, listener));
    }

    @Override
    public <L extends Listener> void add(L listener) {
        this.modify(() -> this.wrapped.add(listener));
    }

    @Override
    public <L extends Listener> void remove(L listener) {
        this.modify(() -> this.wrapped.remove(listener));
    }

    @Override
    public <L extends Listener> void remove(Class<L> listenerClass, L listener) {
        this.modify(() -> this.wrapped.remove(listenerClass, listener));
    }

    @Override
    public <L extends Listener> Stream<L> get(Class<L> listenerClass) {
        return this.read(() -> this.wrapped.get(listenerClass));
    }

    @Override
    public <L extends Listener> void clearAll(Class<L> listenerClass) {
        this.modify(() -> this.wrapped.clearAll(listenerClass));
    }

    @Override
    public void clearAll() {
        this.modify(() -> this.wrapped.clearAll());
    }

    @Override
    public boolean isSequential() {
        return this.wrapped.isSequential();
    }

    @Override
    public void close() {
        this.modify(() -> this.wrapped.close());
    }

    @FunctionalInterface
    protected static interface Transaction {
        public void perform();
    }
}

