/*
 * Decompiled with CFR 0.152.
 */
package de.skuzzle.jeve.stores;

import de.skuzzle.jeve.Listener;
import de.skuzzle.jeve.RegistrationEvent;
import de.skuzzle.jeve.stores.AbstractListenerStore;
import de.skuzzle.jeve.stores.AbstractSynchronizedListenerStore;
import de.skuzzle.jeve.stores.DefaultListenerStore;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;

class DefaultListenerStoreImpl
extends AbstractListenerStore
implements DefaultListenerStore {
    protected final Map<Class<? extends Listener>, List<Object>> listenerMap = new HashMap<Class<? extends Listener>, List<Object>>();
    private SynchronizedStore synchView;

    @Override
    public synchronized DefaultListenerStore synchronizedView() {
        if (this.synchView == null) {
            this.synchView = new SynchronizedStore(this);
        }
        return this.synchView;
    }

    @Override
    protected <T> List<T> createListenerList(int sizeHint) {
        return new ArrayList(sizeHint);
    }

    public <T extends Listener> void add(Class<T> listenerClass, T listener) {
        if (listenerClass == null) {
            throw new IllegalArgumentException("listenerClass is null");
        }
        if (listener == null) {
            throw new IllegalArgumentException("listener is null");
        }
        this.listenerMap.computeIfAbsent(listenerClass, key -> this.createListenerList()).add(listener);
        RegistrationEvent e = new RegistrationEvent(this, (Class<? extends Listener>)listenerClass);
        listener.onRegister(e);
    }

    public <T extends Listener> void remove(Class<T> listenerClass, T listener) {
        if (listenerClass == null || listener == null) {
            return;
        }
        List<Object> targets = this.listenerMap.get(listenerClass);
        if (targets == null) {
            return;
        }
        targets.remove(listener);
        if (targets.isEmpty()) {
            this.listenerMap.remove(listenerClass);
        }
        RegistrationEvent e = new RegistrationEvent(this, (Class<? extends Listener>)listenerClass);
        listener.onUnregister(e);
    }

    public <T extends Listener> Stream<T> get(Class<T> listenerClass) {
        if (listenerClass == null) {
            throw new IllegalArgumentException("listenerClass");
        }
        List targets = this.listenerMap.getOrDefault(listenerClass, Collections.emptyList());
        int sizeHint = targets.size();
        return this.copyList(listenerClass, targets.stream(), sizeHint).stream();
    }

    public <T extends Listener> void clearAll(Class<T> listenerClass) {
        List<Object> targets = this.listenerMap.get(listenerClass);
        this.clearAll(listenerClass, targets, true);
    }

    protected <T extends Listener> void clearAll(Class<T> listenerClass, List<Object> listeners, boolean removeFromMap) {
        if (listeners == null) {
            return;
        }
        for (int i = listeners.size() - 1; i >= 0; --i) {
            Listener listener = (Listener)listenerClass.cast(listeners.remove(i));
            RegistrationEvent e = new RegistrationEvent(this, (Class<? extends Listener>)listenerClass);
            listener.onUnregister(e);
        }
        if (removeFromMap) {
            this.listenerMap.remove(listenerClass);
        }
    }

    @Override
    public void clearAll() {
        this.listenerMap.keySet().forEach(listenerClass -> {
            List<Object> targets = this.listenerMap.get(listenerClass);
            this.clearAll((Class)listenerClass, targets, false);
        });
        this.listenerMap.clear();
    }

    @Deprecated
    protected <T extends Listener> void removeInternal(Class<T> listenerClass, Iterator<Object> it) {
        Object next = it.next();
        Listener listener = (Listener)listenerClass.cast(next);
        it.remove();
        RegistrationEvent e = new RegistrationEvent(this, (Class<? extends Listener>)listenerClass);
        listener.onUnregister(e);
    }

    @Override
    public void close() {
        this.clearAll();
    }

    public String toString() {
        return this.listenerMap.toString();
    }

    @Override
    public boolean isSequential() {
        return true;
    }

    private static class SynchronizedStore
    extends AbstractSynchronizedListenerStore<DefaultListenerStore>
    implements DefaultListenerStore {
        private SynchronizedStore(DefaultListenerStore wrapped) {
            super(wrapped);
        }

        @Override
        public DefaultListenerStore synchronizedView() {
            return this;
        }
    }
}

