/*
 * Decompiled with CFR 0.152.
 */
package de.skuzzle.jeve.stores;

import de.skuzzle.jeve.Listener;
import de.skuzzle.jeve.stores.AbstractSynchronizedListenerStore;
import de.skuzzle.jeve.stores.DefaultListenerStoreImpl;
import de.skuzzle.jeve.stores.PerformanceListenerStore;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Stream;

class PerformanceListenerStoreImpl
extends DefaultListenerStoreImpl
implements PerformanceListenerStore {
    protected boolean optimized;
    protected final boolean autoOptimize;
    private SynchronizedStore synchView;

    public PerformanceListenerStoreImpl() {
        this(false);
    }

    public PerformanceListenerStoreImpl(boolean pAutoOptimize) {
        this.autoOptimize = pAutoOptimize;
    }

    @Override
    public synchronized PerformanceListenerStore synchronizedView() {
        if (this.synchView == null) {
            this.synchView = new SynchronizedStore(this);
        }
        return this.synchView;
    }

    @Override
    public boolean isAutoOptimize() {
        return this.autoOptimize;
    }

    @Override
    public void optimizeGet() {
        if (this.optimized) {
            return;
        }
        this.optimized = true;
        for (Map.Entry entry : this.listenerMap.entrySet()) {
            CopyOnWriteArrayList cpy = new CopyOnWriteArrayList((Collection)entry.getValue());
            entry.setValue(cpy);
        }
    }

    @Override
    protected <T> List<T> createListenerList(int sizeHint) {
        if (this.optimized) {
            return new CopyOnWriteArrayList();
        }
        return super.createListenerList(sizeHint);
    }

    @Override
    public boolean isOptimized() {
        return this.optimized;
    }

    @Override
    public <T extends Listener> Stream<T> get(Class<T> listenerClass) {
        List targets;
        block6: {
            block5: {
                if (listenerClass == null) {
                    throw new IllegalArgumentException("listenerClass");
                }
                if (this.autoOptimize) {
                    this.optimizeGet();
                }
                targets = this.listenerMap.getOrDefault(listenerClass, Collections.emptyList());
                if (this.optimized) break block5;
                if (!targets.isEmpty()) break block6;
            }
            return targets.stream().map(listenerClass::cast);
        }
        int sizeHint = targets.size();
        return this.copyList(listenerClass, targets.stream(), sizeHint).stream();
    }

    private static class SynchronizedStore
    extends AbstractSynchronizedListenerStore<PerformanceListenerStore>
    implements PerformanceListenerStore {
        private SynchronizedStore(PerformanceListenerStore wrapped) {
            super(wrapped);
        }

        @Override
        public PerformanceListenerStore synchronizedView() {
            return this;
        }

        @Override
        public boolean isAutoOptimize() {
            return ((PerformanceListenerStore)this.wrapped).isAutoOptimize();
        }

        @Override
        public boolean isOptimized() {
            return this.read(((PerformanceListenerStore)this.wrapped)::isAutoOptimize);
        }

        @Override
        public void optimizeGet() {
            this.modify(((PerformanceListenerStore)this.wrapped)::optimizeGet);
        }
    }
}

