/*
 * Decompiled with CFR 0.152.
 */
package de.skuzzle.jeve.stores;

import de.skuzzle.jeve.Listener;
import de.skuzzle.jeve.RegistrationEvent;
import de.skuzzle.jeve.stores.AbstractListenerStore;
import de.skuzzle.jeve.stores.AbstractSynchronizedListenerStore;
import de.skuzzle.jeve.stores.PriorityListenerStore;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.stream.Stream;

class PriorityListenerStoreImpl
extends AbstractListenerStore
implements PriorityListenerStore {
    private static final int PRIME = 31;
    private static final int DEFAULT_PRIORITY = 0;
    private final Map<Class<? extends Listener>, List<ListenerWrapper>> listenerMap;
    private final int defaultPriority;
    private SynchronizedStore synchView;

    public PriorityListenerStoreImpl() {
        this(0);
    }

    public PriorityListenerStoreImpl(int defaultPriority) {
        this.defaultPriority = defaultPriority;
        this.listenerMap = new HashMap<Class<? extends Listener>, List<ListenerWrapper>>();
    }

    @Override
    public synchronized PriorityListenerStore synchronizedView() {
        if (this.synchView == null) {
            this.synchView = new SynchronizedStore(this);
        }
        return this.synchView;
    }

    @Override
    protected <T> List<T> createListenerList(int sizeHint) {
        return new LinkedList();
    }

    public <T extends Listener> Stream<T> get(Class<T> listenerClass) {
        if (listenerClass == null) {
            throw new IllegalArgumentException("listenerClass is null");
        }
        List listeners = this.listenerMap.getOrDefault(listenerClass, Collections.emptyList());
        int sizeHint = listeners.size();
        return this.copyList(listenerClass, listeners.stream().map(w -> ((ListenerWrapper)w).listener), sizeHint).stream();
    }

    @Override
    public <T extends Listener> void add(Class<T> listenerClass, T listener) {
        this.add(listenerClass, listener, this.defaultPriority);
    }

    @Override
    public <T extends Listener> void add(Class<T> listenerClass, T listener, int priority) {
        if (listenerClass == null) {
            throw new IllegalArgumentException("listenerClass is null");
        }
        if (listener == null) {
            throw new IllegalArgumentException("listener is null");
        }
        List listeners = this.listenerMap.computeIfAbsent(listenerClass, key -> this.createListenerList());
        this.addSorted(listeners, listener, priority);
        RegistrationEvent e = new RegistrationEvent(this, (Class<? extends Listener>)listenerClass);
        listener.onRegister(e);
    }

    private <L extends Listener> void addSorted(List<ListenerWrapper> listeners, L listener, int listenerPriority) {
        ListIterator<ListenerWrapper> it = listeners.listIterator();
        while (it.hasNext()) {
            ListenerWrapper next = it.next();
            if (listenerPriority >= next.priority) continue;
            it.set(new ListenerWrapper(listener, listenerPriority));
            it.add(next);
            return;
        }
        it.add(new ListenerWrapper(listener, listenerPriority));
    }

    public <T extends Listener> void remove(Class<T> listenerClass, T listener) {
        if (listenerClass == null || listener == null) {
            return;
        }
        List<ListenerWrapper> listeners = this.listenerMap.get(listenerClass);
        if (listeners == null) {
            return;
        }
        ListenerWrapper key = new ListenerWrapper(listener, 0);
        listeners.remove(key);
        if (listeners.isEmpty()) {
            this.listenerMap.remove(listenerClass);
        }
        RegistrationEvent e = new RegistrationEvent(this, (Class<? extends Listener>)listenerClass);
        listener.onUnregister(e);
    }

    @Override
    public void clearAll() {
        this.listenerMap.forEach((k, v) -> {
            Iterator<ListenerWrapper> it = v.iterator();
            while (it.hasNext()) {
                this.removeInternal((Class)k, it, (ListenerWrapper)it.next());
            }
        });
    }

    public <T extends Listener> void clearAll(Class<T> listenerClass) {
        List<ListenerWrapper> listeners = this.listenerMap.get(listenerClass);
        if (listeners != null) {
            Iterator<ListenerWrapper> it = listeners.iterator();
            while (it.hasNext()) {
                this.removeInternal(listenerClass, it, it.next());
            }
        }
    }

    protected <T extends Listener> void removeInternal(Class<T> listenerClass, Iterator<ListenerWrapper> it, ListenerWrapper next) {
        Listener listener = (Listener)listenerClass.cast(next.listener);
        it.remove();
        RegistrationEvent e = new RegistrationEvent(this, (Class<? extends Listener>)listenerClass);
        listener.onUnregister(e);
    }

    @Override
    public void close() {
        this.clearAll();
    }

    public String toString() {
        return this.listenerMap.toString();
    }

    @Override
    public boolean isSequential() {
        return false;
    }

    private static class SynchronizedStore
    extends AbstractSynchronizedListenerStore<PriorityListenerStore>
    implements PriorityListenerStore {
        private SynchronizedStore(PriorityListenerStore wrapped) {
            super(wrapped);
        }

        @Override
        public PriorityListenerStore synchronizedView() {
            return this;
        }

        @Override
        public <T extends Listener> void add(Class<T> listenerClass, T listener, int priority) {
            this.modify(() -> ((PriorityListenerStore)this.wrapped).add(listenerClass, listener, priority));
        }
    }

    private static class ListenerWrapper {
        private final Object listener;
        private final int priority;

        private ListenerWrapper(Object listener, int priority) {
            this.listener = listener;
            this.priority = priority;
        }

        public int hashCode() {
            return 31 * this.listener.hashCode();
        }

        public boolean equals(Object obj) {
            return obj == this || obj != null && obj instanceof ListenerWrapper && this.listener.equals(((ListenerWrapper)obj).listener);
        }

        public String toString() {
            return this.listener.toString();
        }
    }
}

