/*
 * Decompiled with CFR 0.152.
 */
package de.skuzzle.stringz;

import de.skuzzle.stringz.StringzRuntimeException;
import de.skuzzle.stringz.annotation.FieldMapping;
import de.skuzzle.stringz.annotation.ResourceControl;
import de.skuzzle.stringz.annotation.ResourceMapping;
import de.skuzzle.stringz.strategy.ControlFactory;
import de.skuzzle.stringz.strategy.ControlFactoryException;
import de.skuzzle.stringz.strategy.FieldMapper;
import de.skuzzle.stringz.strategy.FieldMapperException;
import de.skuzzle.stringz.strategy.FieldMapperFactory;
import de.skuzzle.stringz.strategy.Strategies;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;

public class CachedStrategies
implements Strategies {
    protected final Map<Class<? extends ControlFactory>, ControlFactory> controlCache = new HashMap<Class<? extends ControlFactory>, ControlFactory>();
    protected final Map<Class<? extends FieldMapperFactory>, FieldMapperFactory> fieldMapperCache = new HashMap<Class<? extends FieldMapperFactory>, FieldMapperFactory>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T> T getCached(Map<Class<? extends T>, T> cache, Class<? extends T> key) throws InstantiationException, IllegalAccessException {
        Map<Class<T>, T> map = cache;
        synchronized (map) {
            T result = cache.get(key);
            if (result == null) {
                try {
                    Constructor<T> ctor = key.getConstructor(new Class[0]);
                    ctor.setAccessible(true);
                    result = ctor.newInstance(new Object[0]);
                    cache.put(key, result);
                }
                catch (IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                    throw new StringzRuntimeException(e);
                }
            }
            return result;
        }
    }

    @Override
    public ResourceBundle.Control getControl(ResourceControl rc, ResourceMapping mapping) throws ControlFactoryException {
        try {
            ControlFactory control = this.getCached(this.controlCache, rc.value());
            return control.create(mapping, rc.args());
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new ControlFactoryException(String.format("Could not create ControlFactory for class %s", rc.value()), e);
        }
    }

    @Override
    public FieldMapper getFieldMapper(FieldMapping fm, ResourceMapping mapping) throws FieldMapperException {
        try {
            FieldMapperFactory control = this.getCached(this.fieldMapperCache, fm.value());
            return control.create(mapping, fm.args());
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new FieldMapperException(String.format("Could not create FieldMapper for class %s", fm.value()), e);
        }
    }
}

