/*
 * Decompiled with CFR 0.152.
 */
package de.skuzzle.stringz;

import de.skuzzle.stringz.CharsetBundleControl;
import de.skuzzle.stringz.annotation.ResourceMapping;
import de.skuzzle.stringz.strategy.ControlFactory;
import de.skuzzle.stringz.strategy.ControlFactoryException;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ResourceBundle;

public class CharsetBundleControlFactory
implements ControlFactory {
    @Override
    public ResourceBundle.Control create(ResourceMapping mapping, String[] args) {
        Charset charset;
        if (args.length != 0) {
            throw new ControlFactoryException("This class has no additional parameters");
        }
        try {
            charset = Charset.forName(mapping.encoding());
        }
        catch (UnsupportedCharsetException e) {
            throw new ControlFactoryException(String.format("Unsupported charset: %s", args[0]), e);
        }
        return new CharsetBundleControl(charset);
    }
}

