/*
 * Decompiled with CFR 0.152.
 */
package de.skuzzle.stringz;

import de.skuzzle.stringz.strategy.BundleFamilyException;
import de.skuzzle.stringz.strategy.BundleFamilyLocator;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Optional;

public class DefaultBundleFamilyLocator
implements BundleFamilyLocator {
    protected static final String BUNDLE_FAMILY_FIELD = "BUNDLE_FAMILY";

    @Override
    public String locateBundleFamily(Class<?> messages) {
        try {
            return this.findNameByConstant(messages);
        }
        catch (BundleFamilyException e) {
            return this.findNameByClassName(messages);
        }
    }

    protected String getConstantName() {
        return BUNDLE_FAMILY_FIELD;
    }

    protected String findNameByConstant(Class<?> messages) {
        if (messages == null) {
            throw new IllegalArgumentException("messages is null");
        }
        String constant = this.getConstantName();
        Optional<Field> f = Arrays.stream(messages.getFields()).filter(field -> Modifier.isStatic(field.getModifiers()) && Modifier.isPublic(field.getModifiers()) && Modifier.isFinal(field.getModifiers()) && field.getType() == String.class && field.getName().equals(constant)).findFirst();
        if (!f.isPresent()) {
            throw new BundleFamilyException(String.format("Class %s has no public static field with name %s", messages.getName(), constant));
        }
        try {
            return (String)f.get().get(null);
        }
        catch (IllegalAccessException e) {
            throw new BundleFamilyException(String.format("Field %s of class %s inaccessible", constant, messages.getName()));
        }
    }

    protected String findNameByClassName(Class<?> messages) {
        Package pack = messages.getPackage();
        String cname = messages.getSimpleName();
        if (cname.isEmpty()) {
            throw new BundleFamilyException(String.format("Class %s seems to be anonymous", messages.getName()));
        }
        String family = String.format("%s.%s", pack.getName(), cname);
        return family;
    }
}

