/*
 * Decompiled with CFR 0.152.
 */
package de.skuzzle.stringz;

import de.skuzzle.stringz.annotation.Delimiter;
import de.skuzzle.stringz.annotation.NoResource;
import de.skuzzle.stringz.annotation.ResourceCollection;
import de.skuzzle.stringz.annotation.ResourceKey;
import de.skuzzle.stringz.annotation.ResourceMapping;
import de.skuzzle.stringz.strategy.FieldMapper;
import de.skuzzle.stringz.strategy.FieldMapperException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ResourceBundle;

public class DefaultFieldMapper
implements FieldMapper {
    private static final String DEFAULT_DELIMITER = ";";

    @Override
    public boolean accept(Field field) {
        return Modifier.isPublic(field.getModifiers()) && !Modifier.isFinal(field.getModifiers()) && (field.getType() == String.class || field.getType() == String[].class) && !field.isAnnotationPresent(NoResource.class);
    }

    @Override
    public void mapField(ResourceMapping mapping, Field field, ResourceBundle bundle) {
        String[] value;
        field.setAccessible(true);
        if (field.getType() == String.class) {
            String resourceKey = this.getResourceKey(field);
            value = this.getValue(mapping, bundle, resourceKey);
        } else if (field.getType() == String[].class) {
            if (field.isAnnotationPresent(ResourceCollection.class)) {
                ResourceCollection rc = field.getAnnotation(ResourceCollection.class);
                String[] v = new String[rc.value().length];
                for (int i = 0; i < v.length; ++i) {
                    String resourceKey = rc.value()[i];
                    v[i] = this.getValue(mapping, bundle, resourceKey);
                }
                value = v;
            } else {
                String delimiterPattern;
                if (field.isAnnotationPresent(Delimiter.class)) {
                    Delimiter delimiter = field.getAnnotation(Delimiter.class);
                    delimiterPattern = delimiter.value();
                } else {
                    delimiterPattern = DEFAULT_DELIMITER;
                }
                String resourceKey = this.getResourceKey(field);
                String resource = this.getValue(mapping, bundle, resourceKey);
                value = resource.split(delimiterPattern);
            }
        } else {
            throw new IllegalStateException();
        }
        try {
            field.set(null, value);
        }
        catch (IllegalAccessException e) {
            throw new FieldMapperException(String.format("Resource initialization failed. family=%s, field=%s, value=%s", mapping.value(), field.getName(), value), e);
        }
    }

    protected String getDefaultDelimiter() {
        return DEFAULT_DELIMITER;
    }

    protected String getValue(ResourceMapping mapping, ResourceBundle bundle, String resourceKey) {
        String value = bundle.getString(resourceKey);
        return mapping.intern() ? value.intern() : value;
    }

    protected String getResourceKey(Field field) {
        if (field.isAnnotationPresent(ResourceKey.class)) {
            ResourceKey rk = field.getAnnotation(ResourceKey.class);
            return rk.value();
        }
        return field.getName();
    }
}

