/*
 * Decompiled with CFR 0.152.
 */
package de.skuzzle.stringz;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class ExtendedBundle
extends ResourceBundle {
    private static final String INCLUDE_KEY = "@include";
    private static final Pattern REPLACE = Pattern.compile("\\$\\{([^}]+)\\}");
    private final ResourceBundle wrapped;
    private final ResourceBundle.Control control;
    private final Locale locale;
    private final String baseName;
    private final List<ResourceBundle> includes;

    public static ResourceBundle getBundle(String baseName, Locale targetLocale, ClassLoader loader, ResourceBundle.Control control) {
        ResourceBundle bundle = ResourceBundle.getBundle(baseName, targetLocale, loader, control);
        return new ExtendedBundle(bundle, baseName, targetLocale, control);
    }

    private ExtendedBundle(ResourceBundle wrapped, String baseName, Locale locale, ResourceBundle.Control control) {
        if (wrapped == null) {
            throw new IllegalArgumentException("wrapped is null");
        }
        if (control == null) {
            throw new IllegalArgumentException("control is null");
        }
        if (locale == null) {
            throw new IllegalArgumentException("locale is null");
        }
        this.baseName = baseName;
        this.wrapped = wrapped;
        this.control = control;
        this.locale = locale;
        this.includes = new ArrayList<ResourceBundle>();
        if (this.wrapped.containsKey(INCLUDE_KEY)) {
            String[] includes;
            String includeString = this.wrapped.getString(INCLUDE_KEY);
            for (String includeName : includes = includeString.split(";")) {
                ResourceBundle include = ExtendedBundle.getBundle(includeName, this.locale, this.getClass().getClassLoader(), this.control);
                this.includes.add(include);
            }
        }
    }

    private Object findObject(String key) {
        try {
            return this.wrapped.getObject(key);
        }
        catch (MissingResourceException e) {
            for (ResourceBundle bundle : this.includes) {
                try {
                    return bundle.getObject(key);
                }
                catch (MissingResourceException e1) {
                }
            }
            throw new MissingResourceException(String.format("Could not locate resource %s", key), this.getClass().getName(), key);
        }
    }

    @Override
    protected Object handleGetObject(String key) {
        boolean replaced;
        Object value = this.findObject(key);
        if (value == null || !(value instanceof String)) {
            return value;
        }
        String s = (String)value;
        do {
            replaced = false;
            Matcher m = REPLACE.matcher(s);
            StringBuilder temp = new StringBuilder(s.length());
            MatchResult lastMatch = null;
            while (m.find()) {
                if (lastMatch == null) {
                    temp.append(s.substring(0, m.start()));
                } else {
                    temp.append(s.substring(lastMatch.end(), m.start()));
                }
                String subkey = m.group(1);
                Object subvalue = this.findObject(subkey);
                temp.append(subvalue);
                lastMatch = m.toMatchResult();
                replaced = true;
            }
            if (lastMatch != null) {
                temp.append(s.substring(lastMatch.end(), s.length()));
            }
            String string = s = replaced ? temp.toString() : s;
        } while (replaced);
        return s;
    }

    @Override
    public Enumeration<String> getKeys() {
        return this.wrapped.getKeys();
    }

    public String toString() {
        return String.format("baseName=%s, includes=%s", this.baseName, this.includes.toString());
    }
}

