/*
 * Decompiled with CFR 0.152.
 */
package de.skuzzle.stringz;

import de.skuzzle.stringz.CachedStrategies;
import de.skuzzle.stringz.CharsetBundleControl;
import de.skuzzle.stringz.DefaultBundleFamilyLocator;
import de.skuzzle.stringz.DefaultFieldMapper;
import de.skuzzle.stringz.ExtendedBundle;
import de.skuzzle.stringz.annotation.FamilyLocator;
import de.skuzzle.stringz.annotation.FieldMapping;
import de.skuzzle.stringz.annotation.ResourceControl;
import de.skuzzle.stringz.annotation.ResourceMapping;
import de.skuzzle.stringz.strategy.BundleFamilyException;
import de.skuzzle.stringz.strategy.BundleFamilyLocator;
import de.skuzzle.stringz.strategy.FieldMapper;
import de.skuzzle.stringz.strategy.FieldMapperException;
import de.skuzzle.stringz.strategy.Strategies;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;

public final class Stringz {
    private static final Map<Class<? extends BundleFamilyLocator>, BundleFamilyLocator> FAMILY_LOCATORS = new HashMap<Class<? extends BundleFamilyLocator>, BundleFamilyLocator>();
    private static final Set<Class<?>> initialized = new HashSet();
    private static final FieldMapper DEFAULT_FIELD_MAPPER = new DefaultFieldMapper();
    private static final Strategies DEFAULT_STRATEGIES = new CachedStrategies();
    private static volatile Locale locale = Locale.getDefault();
    private static volatile Strategies strategies = DEFAULT_STRATEGIES;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerLocator(BundleFamilyLocator locator) {
        Map<Class<? extends BundleFamilyLocator>, BundleFamilyLocator> map = FAMILY_LOCATORS;
        synchronized (map) {
            FAMILY_LOCATORS.put(locator.getClass(), locator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static BundleFamilyLocator getLocator(Class<? extends BundleFamilyLocator> cls) {
        Map<Class<? extends BundleFamilyLocator>, BundleFamilyLocator> map = FAMILY_LOCATORS;
        synchronized (map) {
            BundleFamilyLocator locator = FAMILY_LOCATORS.get(cls);
            if (locator == null) {
                throw new BundleFamilyException(String.format("No BundleFamilyLocator registered for '%s'", cls.getName()));
            }
            return locator;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setLocale(Locale locale) {
        locale = locale == null ? Locale.getDefault() : locale;
        boolean eq = locale.equals(Stringz.locale);
        Stringz.locale = locale;
        if (!eq) {
            Set<Class<?>> set = initialized;
            synchronized (set) {
                ArrayList copy = new ArrayList(initialized);
                initialized.clear();
                copy.forEach(cls -> Stringz.init(cls, locale));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setStrategies(Strategies strategies) {
        Strategies strategies2 = DEFAULT_STRATEGIES;
        synchronized (strategies2) {
            Stringz.strategies = strategies = strategies == null ? DEFAULT_STRATEGIES : strategies;
        }
    }

    private Stringz() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void init(Class<?> cls, Locale locale) {
        if (cls == null) {
            throw new IllegalArgumentException("cls is null");
        }
        if (locale == null) {
            throw new IllegalArgumentException("locale is null");
        }
        if (!cls.isAnnotationPresent(ResourceMapping.class)) {
            throw new IllegalArgumentException(String.format("Class %s does not specify a ResourceMapping annotation", cls));
        }
        Set<Class<?>> set = initialized;
        synchronized (set) {
            if (!initialized.add(cls)) {
                return;
            }
        }
        ResourceMapping rm = cls.getAnnotation(ResourceMapping.class);
        String baseName = Stringz.findBaseName(cls, rm);
        ResourceBundle.Control control = Stringz.findControl(cls, rm);
        ResourceBundle bundle = ExtendedBundle.getBundle(baseName, locale, cls.getClassLoader(), control);
        FieldMapper fieldMapper = Stringz.findFieldMapper(cls, rm);
        Arrays.stream(cls.getFields()).filter(field -> Modifier.isStatic(field.getModifiers())).filter(fieldMapper::accept).forEach(field -> fieldMapper.mapField(rm, (Field)field, bundle));
    }

    public static void init(Class<?> cls) {
        Stringz.init(cls, locale);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dispose(Class<?> cls) {
        if (cls == null) {
            throw new IllegalArgumentException("cls is null");
        }
        if (!cls.isAnnotationPresent(ResourceMapping.class)) {
            throw new IllegalArgumentException(String.format("Class %s does not specify a ResourceMapping annotation", cls));
        }
        Set<Class<?>> set = initialized;
        synchronized (set) {
            if (!initialized.remove(cls)) {
                return;
            }
        }
        ResourceMapping mapping = cls.getAnnotation(ResourceMapping.class);
        FieldMapper mapper = Stringz.findFieldMapper(cls, mapping);
        Arrays.stream(cls.getFields()).filter(mapper::accept).forEach(field -> {
            try {
                field.set(null, null);
            }
            catch (Exception e) {
                throw new FieldMapperException(e);
            }
        });
    }

    public static String get(Class<?> msg, String field) {
        try {
            Field f = msg.getField(field);
            if (!Modifier.isStatic(f.getModifiers())) {
                throw new IllegalArgumentException(String.format("Field '%s' is not static", field));
            }
            if (f.getType() != String.class) {
                return null;
            }
            return (String)f.get(null);
        }
        catch (NoSuchFieldException e) {
            return null;
        }
        catch (SecurityException e) {
            e.printStackTrace();
            return null;
        }
        catch (IllegalArgumentException e) {
            return null;
        }
        catch (IllegalAccessException e) {
            return null;
        }
    }

    private static String findBaseName(Class<?> cls, ResourceMapping rm) {
        String baseName;
        if (rm.value().isEmpty()) {
            Class locatorClass;
            if (cls.isAnnotationPresent(FamilyLocator.class)) {
                FamilyLocator fl = cls.getAnnotation(FamilyLocator.class);
                locatorClass = fl.value();
            } else {
                locatorClass = DefaultBundleFamilyLocator.class;
            }
            BundleFamilyLocator familyLocator = Stringz.getLocator(locatorClass);
            baseName = familyLocator.locateBundleFamily(cls);
        } else {
            baseName = rm.value();
        }
        return baseName;
    }

    private static ResourceBundle.Control findControl(Class<?> cls, ResourceMapping mapping) {
        if (cls.isAnnotationPresent(ResourceControl.class)) {
            ResourceControl rc = cls.getAnnotation(ResourceControl.class);
            return strategies.getControl(rc, mapping);
        }
        return new CharsetBundleControl(mapping.encoding());
    }

    private static FieldMapper findFieldMapper(Class<?> cls, ResourceMapping mapping) {
        if (cls.isAnnotationPresent(FieldMapping.class)) {
            FieldMapping fm = cls.getAnnotation(FieldMapping.class);
            return strategies.getFieldMapper(fm, mapping);
        }
        return DEFAULT_FIELD_MAPPER;
    }

    static {
        Stringz.registerLocator(new DefaultBundleFamilyLocator());
    }
}

