/*
 * Decompiled with CFR 0.152.
 */
package de.skuzzle.stringz.rstring;

import java.util.HashMap;
import java.util.Map;

class RString {
    private static final Map<String, RString> INTERN_CACHE = new HashMap<String, RString>();
    public static final RString EMPTY = new RString("").intern();
    public final String s;
    public final int length;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RString intern(String s) {
        Map<String, RString> map = INTERN_CACHE;
        synchronized (map) {
            RString result = INTERN_CACHE.get(s);
            if (result == null) {
                result = new RString(s);
                INTERN_CACHE.put(s, result);
            }
            return result;
        }
    }

    public RString(String s) {
        if (s == null) {
            throw new IllegalArgumentException("s is null");
        }
        this.s = s;
        this.length = s.length();
    }

    public RString intern() {
        return RString.intern(this.s.intern());
    }

    public String s(Object ... args) {
        return String.format(this.s, args);
    }

    public String toString() {
        return this.s;
    }

    public int hashCode() {
        return this.s.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return true;
        }
        if (obj instanceof String) {
            return this.s.equals(obj);
        }
        if (obj instanceof RString) {
            return this.s.equals(((RString)obj).s);
        }
        return false;
    }
}

