/*
 * Decompiled with CFR 0.152.
 */
package de.skuzzle.stringz.rstring;

import de.skuzzle.stringz.DefaultFieldMapper;
import de.skuzzle.stringz.annotation.NoResource;
import de.skuzzle.stringz.annotation.ResourceMapping;
import de.skuzzle.stringz.rstring.RString;
import de.skuzzle.stringz.strategy.FieldMapperException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

class RStringFieldMapper
extends DefaultFieldMapper {
    RStringFieldMapper() {
    }

    @Override
    public boolean accept(Field field) {
        int m = field.getModifiers();
        return Modifier.isStatic(m) && !Modifier.isFinal(m) && Modifier.isPublic(m) && !field.isAnnotationPresent(NoResource.class) && RString.class.isAssignableFrom(field.getType());
    }

    @Override
    public void mapField(ResourceMapping mapping, Field field, ResourceBundle bundle) throws FieldMapperException, MissingResourceException {
        field.setAccessible(true);
        String resourceKey = this.getResourceKey(field);
        String value = this.getValue(mapping, bundle, resourceKey);
        RString extValue = mapping.intern() ? RString.intern(value) : new RString(value);
        try {
            field.set(null, extValue);
        }
        catch (IllegalAccessException e) {
            throw new FieldMapperException(String.format("Resource initialization failed. family=%s, field=%s, value=%s", mapping.value(), field.getName(), value), e);
        }
    }
}

