/*
 * Decompiled with CFR 0.152.
 */
package de.skuzzle.tinyplugz;

import de.skuzzle.tinyplugz.DeployListener;
import de.skuzzle.tinyplugz.PluginInformation;
import de.skuzzle.tinyplugz.PluginSource;
import de.skuzzle.tinyplugz.TinyPlugzConfigurator;
import de.skuzzle.tinyplugz.TinyPlugzException;
import de.skuzzle.tinyplugz.internal.DelegateClassLoader;
import de.skuzzle.tinyplugz.util.Closeables;
import de.skuzzle.tinyplugz.util.ElementIterator;
import de.skuzzle.tinyplugz.util.Require;
import java.io.Closeable;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;

public abstract class TinyPlugz {
    private static volatile TinyPlugz instance;

    public static TinyPlugz getInstance() {
        TinyPlugz plugz = instance;
        Require.state(plugz != null, "TinyPlugz has not been initialized", new Object[0]);
        return plugz;
    }

    static void deploy(TinyPlugz instance) {
        TinyPlugz.instance = instance;
    }

    public static boolean isDeployed() {
        return instance != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void undeploy() {
        Object object = TinyPlugzConfigurator.DEPLOY_LOCK;
        synchronized (object) {
            Require.state(TinyPlugz.isDeployed(), "Can not undeploy TinyPlugz: no instance deployed", new Object[0]);
            TinyPlugz plugz = instance;
            Require.state(plugz == this, "Undeploy called on an instance which was not the deployed one", new Object[0]);
            instance = null;
            plugz.dispose();
        }
    }

    protected abstract void initialize(PluginSource var1, ClassLoader var2, Map<Object, Object> var3);

    protected abstract Iterator<DeployListener> findDeployListeners(ClassLoader var1);

    protected abstract void dispose();

    protected final void defaultDispose() {
        if (this.getClassLoader() instanceof Closeable) {
            Closeable cl = (Closeable)((Object)this.getClassLoader());
            Closeables.safeClose(cl);
        }
    }

    public abstract void runMain(String var1, String[] var2);

    protected final void defaultRunMain(String className, String[] args) {
        try {
            boolean methodValid;
            Thread.currentThread().setContextClassLoader(this.getClassLoader());
            Class<?> cls = this.getClassLoader().loadClass(className);
            Method method = cls.getMethod("main", String[].class);
            boolean bl = methodValid = method != null && Modifier.isPublic(method.getModifiers()) && Modifier.isStatic(method.getModifiers()) && method.getReturnType() == Void.TYPE;
            if (!methodValid) {
                throw new TinyPlugzException(String.format("The main() method in class '%s' not found.", cls.getName()));
            }
            Require.nonNull(method).invoke(null, new Object[]{args});
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new TinyPlugzException(e);
        }
    }

    public abstract Collection<PluginInformation> getPluginInformation();

    public abstract ClassLoader getClassLoader();

    protected final DelegateClassLoader createClassLoader(PluginSource source, ClassLoader parent) {
        Stream<URL> urls = Require.nonNullResult(source.getPluginURLs(), "pluginSource.getPluginURLs");
        return DelegateClassLoader.forPlugins(urls, parent);
    }

    public abstract Optional<URL> getResource(String var1);

    protected final Optional<URL> defaultGetResource(String name) {
        return Optional.ofNullable(this.getClassLoader().getResource(name));
    }

    public abstract ElementIterator<URL> getResources(String var1) throws IOException;

    protected final ElementIterator<URL> defaultGetResources(String name) throws IOException {
        Enumeration<URL> e = this.getClassLoader().getResources(name);
        return ElementIterator.wrap(e);
    }

    public final boolean isServiceAvailable(Class<?> service) {
        return this.getFirstService(service).isPresent();
    }

    public abstract <T> ElementIterator<T> getServices(Class<T> var1);

    public abstract <T> Optional<T> getFirstService(Class<T> var1);

    protected final <T> Optional<T> defaultGetFirstService(Class<T> type) {
        ElementIterator<T> services = this.getServices(type);
        return services.hasNext() ? Optional.of(services.next()) : Optional.empty();
    }

    public abstract <T> T getService(Class<T> var1);

    protected final <T> T defaultGetService(Class<T> type) {
        ElementIterator<T> services = this.getServices(type);
        Require.state(services.hasNext(), "no provider for service '%s' found", type.getName());
        Object first = services.next();
        Require.state(!services.hasNext(), "there are multiple providers for the service '%s'", type.getName());
        return (T)first;
    }
}

