/*
 * Decompiled with CFR 0.152.
 */
package de.skuzzle.tinyplugz;

import de.skuzzle.tinyplugz.DeployListener;
import de.skuzzle.tinyplugz.PluginSource;
import de.skuzzle.tinyplugz.PluginSourceBuilder;
import de.skuzzle.tinyplugz.TinyPlugz;
import de.skuzzle.tinyplugz.TinyPlugzException;
import de.skuzzle.tinyplugz.internal.PluginSourceBuilderImpl;
import de.skuzzle.tinyplugz.internal.ServiceLoaderWrapper;
import de.skuzzle.tinyplugz.internal.TinyPlugzLookUp;
import de.skuzzle.tinyplugz.util.ReflectionUtil;
import de.skuzzle.tinyplugz.util.Require;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.function.Consumer;
import org.eclipse.jdt.annotation.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TinyPlugzConfigurator {
    public static final @NonNull String TINY_PLUGZ_CONFIG = "tiny-plugz.properties";
    private static final Logger LOG = LoggerFactory.getLogger(TinyPlugz.class);
    protected static final Object DEPLOY_LOCK = new Object();

    private TinyPlugzConfigurator() {
    }

    public static DefineProperties setup() {
        ClassLoader cl = Require.nonNull(Thread.currentThread().getContextClassLoader());
        return new Impl(cl);
    }

    public static DefineProperties setupUsingParent(ClassLoader parentClassLoader) {
        return new Impl(Require.nonNull(parentClassLoader, "parentClassLoader"));
    }

    public static DefineProperties setupUsingApplicationClassLoader() {
        ClassLoader cl = Require.nonNull(TinyPlugzConfigurator.class.getClassLoader());
        return new Impl(cl);
    }

    private static final class Impl
    implements DefineProperties,
    DeployTinyPlugz {
        private static final @NonNull Object NON_NULL_VALUE = new Object();
        private final @NonNull Map<Object, Object> properties;
        private final @NonNull ClassLoader parentCl;
        private PluginSource source;

        private Impl(@NonNull ClassLoader parentCl) {
            this.parentCl = parentCl;
            this.properties = new HashMap<Object, Object>();
        }

        @Override
        public DefineProperties withClasspathProperties() {
            return this.withClasspathProperties(TinyPlugzConfigurator.TINY_PLUGZ_CONFIG);
        }

        @Override
        public DefineProperties withClasspathProperties(String resourceName) {
            Require.nonNull(resourceName, "resourceName");
            URL url = Require.nonNullResult(this.parentCl.getResource(resourceName), "ClassLoader.getResource");
            Properties props = new Properties();
            try (InputStream in = url.openStream();){
                props.load(in);
            }
            catch (IOException e) {
                throw new IllegalStateException(String.format("Resource <%s> could not be read", resourceName), e);
            }
            this.properties.putAll(props);
            return this;
        }

        @Override
        public DefineProperties withProperty(String name, Object value) {
            Require.nonNull(name, "name");
            this.properties.put(name, value);
            return this;
        }

        @Override
        public DefineProperties withProperty(String name) {
            return this.withProperty(name, NON_NULL_VALUE);
        }

        @Override
        public DefineProperties withSystemProperties() {
            return this.withProperties(Require.nonNull(System.getProperties()));
        }

        @Override
        public DefineProperties withProperties(Map<? extends Object, ? extends Object> values) {
            Require.nonNull(values, "values");
            this.properties.putAll(values);
            return this;
        }

        @Override
        public DeployTinyPlugz withPlugins(Consumer<PluginSourceBuilder> source) {
            Require.nonNull(source, "source");
            PluginSourceBuilder builder = PluginSource.builder();
            source.accept(builder);
            this.source = builder.createSource();
            return this;
        }

        @Override
        public DeployTinyPlugz withPlugins(PluginSource source) {
            Require.nonNull(source, "source");
            this.source = source;
            return this;
        }

        @Override
        public TinyPlugz createInstance() {
            this.validateProperties();
            TinyPlugz impl = this.getInstance();
            LOG.debug("Using '{}' TinyPlugz implementation", (Object)impl.getClass().getName());
            PluginSource pluginSource = this.buildSource();
            this.logProperties();
            impl.initialize(pluginSource, this.parentCl, Collections.unmodifiableMap(this.properties));
            return impl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public TinyPlugz deploy() {
            this.validateProperties();
            Object object = DEPLOY_LOCK;
            synchronized (object) {
                Require.state(!TinyPlugz.isDeployed(), "TinyPlugz already deployed", new Object[0]);
                TinyPlugz impl = this.createInstance();
                TinyPlugz.deploy(impl);
                this.notifyListeners(impl);
                return impl;
            }
        }

        private PluginSource buildSource() {
            PluginSourceBuilderImpl builder = new PluginSourceBuilderImpl();
            if (this.properties.get("tinyplugz.pluginFolder") != null) {
                String p = this.properties.get("tinyplugz.pluginFolder").toString();
                Path path = Paths.get(p, new String[0]);
                if (this.source == null) {
                    builder.addAllPluginJars(path);
                } else {
                    builder.include(this.source).addAllPluginJars(path);
                }
            } else if (this.source == null) {
                LOG.warn("TinyPlugz has been configured without specifying any plugin sources");
            } else {
                builder.include(this.source);
            }
            return builder.createSource();
        }

        private void notifyListeners(TinyPlugz tinyPlugz) {
            Iterator<DeployListener> listeners = tinyPlugz.findDeployListeners(tinyPlugz.getClassLoader());
            Require.nonNullResult(listeners, "TinyPlugz.findDeployListeners");
            while (listeners.hasNext()) {
                DeployListener next = Require.nonNullResult(listeners.next(), "Iterator.next");
                try {
                    next.initialized(tinyPlugz, this.properties);
                }
                catch (RuntimeException e) {
                    LOG.error("DeployListener '{}' threw exception", (Object)next, (Object)e);
                }
            }
        }

        private TinyPlugz getInstance() {
            TinyPlugzLookUp lookup = this.properties.get("tinyplugz.forceDefault") != null ? TinyPlugzLookUp.DEFAULT_INSTANCE_STRATEGY : (this.properties.get("tinyplugz.forceImplementation") != null ? TinyPlugzLookUp.STATIC_STRATEGY : TinyPlugzLookUp.SPI_STRATEGY);
            ServiceLoaderWrapper serviceLoader = this.properties.get("tinyplugz.serviceLoaderWrapper") != null ? ReflectionUtil.createInstance(this.properties.get("tinyplugz.serviceLoaderWrapper"), ServiceLoaderWrapper.class, this.parentCl) : ServiceLoaderWrapper.getDefault();
            LOG.debug("Using '{}' for instantiating TinyPlugz", (Object)((Object)((Object)lookup)).getClass().getName());
            return lookup.getInstance(this.parentCl, serviceLoader, this.properties);
        }

        private void validateProperties() {
            Object forceDefault = this.properties.get("tinyplugz.forceDefault");
            Object forceImplementation = this.properties.get("tinyplugz.forceImplementation");
            if (forceDefault != null && forceImplementation != null) {
                throw new TinyPlugzException("Can not use 'FORCE_IMPLEMENTATION' together with 'FORCE_DEFAULT'");
            }
        }

        private void logProperties() {
            if (!LOG.isDebugEnabled() || this.properties.isEmpty()) {
                return;
            }
            StringBuilder b = new StringBuilder();
            b.append("TinyPlugz configuration options:\n");
            this.properties.forEach((k, v) -> {
                b.append("\t").append(k);
                if (!NON_NULL_VALUE.equals(v)) {
                    b.append(":\t").append(v);
                }
                b.append("\n");
            });
            LOG.debug(b.toString());
        }
    }

    public static interface DeployTinyPlugz {
        public TinyPlugz createInstance();

        public TinyPlugz deploy();
    }

    public static interface DefineProperties
    extends DeployTinyPlugz {
        public DefineProperties withClasspathProperties();

        public DefineProperties withClasspathProperties(String var1);

        public DefineProperties withProperty(String var1, Object var2);

        public DefineProperties withProperty(String var1);

        public DefineProperties withSystemProperties();

        public DefineProperties withProperties(Map<? extends Object, ? extends Object> var1);

        public DeployTinyPlugz withPlugins(Consumer<PluginSourceBuilder> var1);

        public DeployTinyPlugz withPlugins(PluginSource var1);

        @Override
        public TinyPlugz deploy();
    }
}

